(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    223461,       4716]
NotebookOptionsPosition[    222935,       4698]
NotebookOutlinePosition[    223366,       4715]
CellTagsIndexPosition[    223323,       4712]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"VectorQ", "[", "GVl20", "]"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"MemberQ", "[", 
         RowBox[{"GVl20", ",", "Null"}], "]"}], "\[Equal]", "False"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GVl20", "\[NotEqual]", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MatrixQ", "[", "GVl21", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{
                RowBox[{"ToCharacterCode", "[", 
                 RowBox[{"ToString", "[", "GVl21", "]"}], "]"}], ",", 
                "62760"}], "]"}], "\[Equal]", "False"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"Dimensions", "[", "GVl21", "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"MemberQ", "[", 
                   RowBox[{
                    RowBox[{"Flatten", "[", "GVl21", "]"}], ",", "Null"}], 
                   "]"}], "\[Equal]", "False"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"VectorQ", "[", "GVl22", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"GVl22", ",", "Null"}], "]"}], "\[Equal]", 
                    "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GVl22", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "GVl22", "]"}], "\[Equal]", 
                    RowBox[{"Length", "[", "GVl21", "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"GVl20", ",", "GVl24"}], "]"}], "&&", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"GVl20", ",", "GVl25"}], "]"}]}], ",", 
                    RowBox[{"Column", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"GGrafoAuxiliar17", "=", 
                    RowBox[{"Grafo", "[", 
                    RowBox[{"GVl21", ",", 
                    RowBox[{"vertices", "\[Rule]", "GVl20"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "GVl23"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl22"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", "True"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"Valencias", "[", "GGrafoAuxiliar17", "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Cantidad de v\[EAcute]rtices: \>\"", ",", " ", 
                    RowBox[{"CantNodos", "[", "GGrafoAuxiliar17", "]"}]}], 
                    "}"}], "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Cantidad de aristas: \>\"", ",", " ", 
                    RowBox[{"CantAristas", "[", "GGrafoAuxiliar17", "]"}]}], 
                    "}"}], "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Grafo conexo: \>\"", ",", 
                    RowBox[{"ConnectedGraphQ", "[", "GGrafoAuxiliar17", 
                    "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Matriz de adjacencia: \>\"", ",", 
                    RowBox[{"MGrafo", "[", 
                    RowBox[{"GGrafoAuxiliar17", ",", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar17", "]"}], ",", 
                    RowBox[{"table", "\[Rule]", "True"}]}], "]"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Matriz de adjacencia de pesos: \>\"", ",", 
                    RowBox[{"MPGrafo", "[", 
                    RowBox[{"GGrafoAuxiliar17", ",", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar17", "]"}], ",", 
                    RowBox[{"table", "\[Rule]", "True"}]}], "]"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Matriz de inicidencia: \>\"", ",", 
                    RowBox[{"MIGrafo", "[", 
                    RowBox[{"GGrafoAuxiliar17", ",", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar17", "]"}], ",", 
                    RowBox[{"table", "\[Rule]", "True"}]}], "]"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Circuito de Euler: \>\"", ",", 
                    RowBox[{
                    "FindEulerianCycle", "[", "GGrafoAuxiliar17", "]"}]}], 
                    "}"}], "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Circuito de Hamilton: \>\"", ",", 
                    RowBox[{
                    "FindHamiltonianCycle", "[", "GGrafoAuxiliar17", "]"}]}], 
                    "}"}], "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Ruta de longitud m\[AAcute]s corta: \>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "GrafoPonderadoNQ", "[", "GGrafoAuxiliar17", "]"}], ",", 
                    RowBox[{"FindShortestPath", "[", 
                    RowBox[{"GGrafoAuxiliar17", ",", "GVl24", ",", "GVl25"}], 
                    "]"}], ",", "\"\<\>\""}], "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "GrafoPonderadoNQ", "[", "GGrafoAuxiliar17", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"FindShortestPath", "[", 
                    RowBox[{"GGrafoAuxiliar17", ",", "GVl24", ",", "GVl25"}], 
                    "]"}], "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"ResaltarRuta", "[", 
                    RowBox[{"GGrafoAuxiliar17", ",", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"FindShortestPath", "[", 
                    RowBox[{"GGrafoAuxiliar17", ",", "GVl24", ",", "GVl25"}], 
                    "]"}], ",", "2", ",", "1"}], "]"}]}], "]"}], ",", 
                    "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}]}], "}"}], 
                    "]"}], ",", "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}],
                     ",", "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}], ",", 
                   "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}], ",", 
               "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}], ",", 
           "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], 
      "]"}], ",", "\"\<\>\""}], "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Elementos del grafo\>\"", ",", "Bold", ",", "Medium"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"GVl20", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
      "\"\<V\[EAcute]rtices\>\""}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"GVl21", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"b", ",", "c"}], "}"}]}], "}"}], ",", "\"\<Aristas\>\""}], 
     "}"}], "}"}], ",", "Delimiter", ",", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Grafo ponderado\>\"", ",", "Bold", ",", "Medium"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"GVl22", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", "\"\<Pesos de las aristas\>\""}], 
     "}"}], "}"}], ",", "Delimiter", ",", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Grafo dirigido\>\"", ",", "Bold", ",", "Medium"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"GVl23", ",", "False", ",", "\"\<Digrafo\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", "Delimiter", ",", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<Nodos para la ruta del camino m\[AAcute]s corto\>\"", ",", "Bold", 
     ",", "Medium"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"GVl24", ",", "a", ",", "\"\<Nodo 1\>\""}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"GVl25", ",", "c", ",", "\"\<Nodo 2\>\""}], "}"}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Center"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Clear", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], ";", 
      RowBox[{
       RowBox[{
       "AristasWolframSystemToCombinatorica", "[", "GAristasGrafo_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GGrafoAuxiliar1", "=", 
           RowBox[{"System`Graph", "[", "GAristasGrafo", "]"}]}], "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GraphQ", "[", "GGrafoAuxiliar1", "]"}], ",", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GAristasGrafo", ",", 
              RowBox[{"Gicontador1_", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Gicontador1", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador1", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}]}], "]"}], "]"}]}],
           "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "AristasCombinatoricaToWolframSystem", "]"}], 
       "=", 
       RowBox[{"{", 
        RowBox[{"dirigido", "\[Rule]", "False"}], "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"AristasCombinatoricaToWolframSystem", "[", 
        RowBox[{"GAristasGrafo_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GAristasNoDirigidas", ",", "GAristasDirigidas"}], "}"}], 
         ",", 
         RowBox[{
          RowBox[{
           RowBox[{"GAristasNoDirigidas", "[", "GOAritas_", "]"}], ":=", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GOAritas", ",", 
              RowBox[{"Gicontador2_", "\[Rule]", 
               RowBox[{"UndirectedEdge", "[", 
                RowBox[{
                 RowBox[{"Gicontador2", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador2", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}],
           ";", 
          RowBox[{
           RowBox[{"GAristasDirigidas", "[", "GOAritas_", "]"}], ":=", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GOAritas", ",", 
              RowBox[{"Gicontador3_", "\[Rule]", 
               RowBox[{"DirectedEdge", "[", 
                RowBox[{
                 RowBox[{"Gicontador3", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador3", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}],
           ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"MatrixQ", "[", "GAristasGrafo", "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"MemberQ", "[", 
                RowBox[{
                 RowBox[{"ToCharacterCode", "[", 
                  RowBox[{"ToString", "[", "GAristasGrafo", "]"}], "]"}], ",",
                  "62760"}], "]"}], "\[Equal]", "False"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"MemberQ", "[", 
                  RowBox[{
                   RowBox[{"Flatten", "[", "GAristasGrafo", "]"}], ",", 
                   "Null"}], "]"}], "\[Equal]", "False"}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"Dimensions", "[", "GAristasGrafo", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "dirigido", "]"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GAristasGrafo", "]"}], 
                    ",", 
                    RowBox[{
                    "GAristasNoDirigidas", "[", "GAristasGrafo", "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{"AristasMixtasQ", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Select", "[", 
              RowBox[{
               RowBox[{"EdgeList", "[", "GGrafo", "]"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"DirectedEdge", "[", 
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                 "#"}], "&"}]}], "]"}], "\[NotEqual]", 
             RowBox[{"{", "}"}]}], "&&", 
            RowBox[{
             RowBox[{"Select", "[", 
              RowBox[{
               RowBox[{"EdgeList", "[", "GGrafo", "]"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"UndirectedEdge", "[", 
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                 "#"}], "&"}]}], "]"}], "\[NotEqual]", 
             RowBox[{"{", "}"}]}]}], ",", "True", ",", "False"}], "]"}]}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{
       "AristasMixtasWolframSystemToCombinatorica", "[", "GAristasGrafo_", 
        "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GGrafoAuxiliar10", "=", 
           RowBox[{"System`Graph", "[", "GAristasGrafo", "]"}]}], "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GraphQ", "[", "GGrafoAuxiliar10", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"AristasMixtasQ", "[", "GGrafoAuxiliar10", "]"}], ",", 
             RowBox[{"Join", "[", 
              RowBox[{
               RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                RowBox[{"Select", "[", 
                 RowBox[{
                  RowBox[{"EdgeList", "[", "GGrafoAuxiliar10", "]"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"DirectedEdge", "[", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                    "#"}], "&"}]}], "]"}], "]"}], ",", 
               RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                RowBox[{"Select", "[", 
                 RowBox[{
                  RowBox[{"EdgeList", "[", "GGrafoAuxiliar10", "]"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"UndirectedEdge", "[", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                    "#"}], "&"}]}], "]"}], "]"}], ",", 
               RowBox[{"Reverse", "[", 
                RowBox[{
                 RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                  RowBox[{"Select", "[", 
                   RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafoAuxiliar10", "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"UndirectedEdge", "[", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                    "#"}], "&"}]}], "]"}], "]"}], ",", "2"}], "]"}]}], 
              "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "Grafo", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
         RowBox[{"vertices", "\[Rule]", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
         RowBox[{"pesos", "\[Rule]", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"mostrarpesos", "\[Rule]", "False"}], ",", 
         RowBox[{"shape", "\[Rule]", "False"}]}], "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"Grafo", "[", 
        RowBox[{"GAristas_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "GAristasNoDirigidas", ",", "GAristasDirigidas", ",", 
           "GLabelsPesos", ",", "Grafo3d", ",", "GrafoNo3d"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"GAristasNoDirigidas", "[", "GOAritas_", "]"}], ":=", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GOAritas", ",", 
              RowBox[{"Gicontador4_", "\[Rule]", 
               RowBox[{"UndirectedEdge", "[", 
                RowBox[{
                 RowBox[{"Gicontador4", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador4", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}],
           ";", 
          RowBox[{
           RowBox[{"GAristasDirigidas", "[", "GOAritas_", "]"}], ":=", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GOAritas", ",", 
              RowBox[{"Gicontador5_", "\[Rule]", 
               RowBox[{"DirectedEdge", "[", 
                RowBox[{
                 RowBox[{"Gicontador5", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador5", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}],
           ";", 
          RowBox[{
           RowBox[{"GLabelsPesos", "[", 
            RowBox[{"GGrafo_", ",", "GPesos_"}], "]"}], ":=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Length", "[", "GPesos", "]"}], "\[Equal]", 
              RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], ",", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"GList1", "=", 
                  RowBox[{"EdgeList", "[", "GGrafo", "]"}]}], ",", 
                 RowBox[{"GList2", "=", 
                  RowBox[{"{", "}"}]}]}], "}"}], ",", 
               RowBox[{
                RowBox[{"For", "[", 
                 RowBox[{
                  RowBox[{"Gi1", "=", "1"}], ",", 
                  RowBox[{"Gi1", "\[LessEqual]", 
                   RowBox[{"Length", "[", "GList1", "]"}]}], ",", 
                  RowBox[{
                   RowBox[{"GList2", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"GList2", ",", 
                    RowBox[{
                    RowBox[{"GList1", "[", 
                    RowBox[{"[", "Gi1", "]"}], "]"}], "\[Rule]", 
                    RowBox[{"GPesos", "[", 
                    RowBox[{"[", "Gi1", "]"}], "]"}]}]}], "]"}]}], ";", 
                   RowBox[{"Gi1", "++"}]}]}], "]"}], ";", "GList2"}]}], 
              "]"}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"Grafo3d", "[", "GOAristas_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl1", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"OptionValue", "[", "shape", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}], ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], "]"}]}], "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}], 
                   ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}]}], 
                  "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"GrafoNo3d", "[", "GOAristas_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl1", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"OptionValue", "[", "shape", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}], ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], "]"}]}], "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}], 
                   ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}]}], 
                  "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "dirigido", "]"}], "]"}], "&&", 
             RowBox[{"VectorQ", "[", 
              RowBox[{"OptionValue", "[", "vertices", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "dimensions3d", "]"}], "]"}], "&&", 
             RowBox[{"VectorQ", "[", 
              RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "shape", "]"}], "]"}]}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{
                  RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                  "Null"}], "]"}], "\[Equal]", "False"}], "&&", 
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{
                  RowBox[{"OptionValue", "[", "pesos", "]"}], ",", "Null"}], 
                 "]"}], "\[Equal]", "False"}]}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"MatrixQ", "[", "GAristas", "]"}], "||", 
                   RowBox[{
                    RowBox[{"ToString", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}]}], ")"}], "&&", 
                 RowBox[{
                  RowBox[{"MemberQ", "[", 
                   RowBox[{
                    RowBox[{"Flatten", "[", "GAristas", "]"}], ",", "Null"}], 
                   "]"}], "\[Equal]", "False"}]}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"Length", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"Length", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}]}], "||", 
                   RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}]}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], "&&", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], 
                    "\[NotEqual]", 
                    RowBox[{"{", "}"}]}]}], ")"}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"MatrixQ", "[", "GAristas", "]"}], "&&", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "GAristas", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], "&&", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"ToString", "[", "GAristas", "]"}], "]"}], ",", 
                    "62760"}], "]"}], "\[Equal]", "False"}]}], ")"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "dimensions3d", "]"}], ",", 
                    RowBox[{"Grafo3d", "[", "GAristas", "]"}], ",", 
                    RowBox[{"GrafoNo3d", "[", "GAristas", "]"}]}], "]"}]}], 
                   "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], 
      ";", 
      RowBox[{
       RowBox[{"GrafoQ", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GraphQ", "[", "GGrafo", "]"}], ",", "True", ",", "False"}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{"GrafoCQ", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"NumericQ", "[", 
          RowBox[{"V", "[", "GGrafo", "]"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"V", "[", "GGrafo", "]"}], "\[Equal]", "0"}], ",", 
           "False", ",", "True"}], "]"}], ",", "False"}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"PesosAristas", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"WeightedGraphQ", "[", "GGrafo", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"AristasMixtasQ", "[", "GGrafo", "]"}], ",", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"Length", "[", 
                  RowBox[{"Quiet", "[", 
                   RowBox[{"Cases", "[", 
                    RowBox[{
                    RowBox[{"System`EdgeList", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"Gicontador6_", "\[Rule]", " ", 
                    RowBox[{"NumericQ", "[", 
                    RowBox[{"PropertyValue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"GGrafo", ",", "Gicontador6"}], "}"}], ",", 
                    "System`EdgeWeight"}], "]"}], "]"}]}]}], "]"}], "]"}], 
                  "]"}], "\[Equal]", 
                 RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], ",", 
                RowBox[{"GList3", "=", 
                 RowBox[{"Table", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "[", 
                    RowBox[{"[", "Gi2", "]"}], "]"}], ",", 
                    RowBox[{"PropertyValue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"GGrafo", ",", 
                    RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "[", 
                    RowBox[{"[", "Gi2", "]"}], "]"}]}], "}"}], ",", 
                    "System`EdgeWeight"}], "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Gi2", ",", "1", ",", 
                    RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], "}"}]}], 
                  "]"}]}]}], "]"}], ";", 
              RowBox[{"GList4", "=", 
               RowBox[{"Select", "[", 
                RowBox[{"GList3", ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"DirectedEdge", "[", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "]"}], 
                   "\[Equal]", 
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "&"}], ",", "2"}], 
                "]"}]}], ";", 
              RowBox[{"GList5", "=", 
               RowBox[{
                RowBox[{"Select", "[", 
                 RowBox[{"GList3", ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"UndirectedEdge", "[", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "&"}], ",", "2"}], 
                 "]"}], "/.", 
                RowBox[{"UndirectedEdge", "\[Rule]", "DirectedEdge"}]}]}], 
              ";", 
              RowBox[{"Join", "[", 
               RowBox[{"GList4", ",", "GList5", ",", 
                RowBox[{"Reverse", "[", 
                 RowBox[{"GList5", ",", "3"}], "]"}]}], "]"}]}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Length", "[", 
                 RowBox[{"Quiet", "[", 
                  RowBox[{"Cases", "[", 
                   RowBox[{
                    RowBox[{"System`EdgeList", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"Gicontador6_", "\[Rule]", " ", 
                    RowBox[{"NumericQ", "[", 
                    RowBox[{"PropertyValue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"GGrafo", ",", "Gicontador6"}], "}"}], ",", 
                    "System`EdgeWeight"}], "]"}], "]"}]}]}], "]"}], "]"}], 
                 "]"}], "\[Equal]", 
                RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], ",", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "[", 
                    RowBox[{"[", "Gi2", "]"}], "]"}], ",", 
                   RowBox[{"PropertyValue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"GGrafo", ",", 
                    RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "[", 
                    RowBox[{"[", "Gi2", "]"}], "]"}]}], "}"}], ",", 
                    "System`EdgeWeight"}], "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"Gi2", ",", "1", ",", 
                   RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], "}"}]}], 
                "]"}]}], "]"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ListQ", "[", 
              RowBox[{"Edges", "[", 
               RowBox[{"GGrafo", ",", "EdgeWeight"}], "]"}], "]"}], ",", 
             RowBox[{"DeleteDuplicates", "[", 
              RowBox[{"Edges", "[", 
               RowBox[{"GGrafo", ",", "EdgeWeight"}], "]"}], "]"}]}], "]"}]}],
           "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Valencias", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "GGrafoAuxiliar15", "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"AristasMixtasQ", "[", "GGrafo", "]"}], ",", 
             RowBox[{
              RowBox[{"GGrafoAuxiliar15", "=", 
               RowBox[{"Grafo", "[", 
                RowBox[{
                 RowBox[{"AristasMixtasWolframSystemToCombinatorica", "[", 
                  RowBox[{"EdgeList", "[", "GGrafo", "]"}], "]"}], ",", 
                 RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                 RowBox[{"vertices", "\[Rule]", 
                  RowBox[{"VertexList", "[", "GGrafo", "]"}]}]}], "]"}]}], 
              ";", 
              RowBox[{"TableForm", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"VertexInDegree", "[", "GGrafoAuxiliar15", "]"}], 
                  ",", 
                  RowBox[{"VertexOutDegree", "[", "GGrafoAuxiliar15", "]"}]}],
                  "}"}], ",", 
                RowBox[{"TableHeadings", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    "\"\<Grado o valencia interna\>\"", ",", 
                    "\"\<Grado o valencia externa\>\""}], "}"}], ",", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar15", "]"}]}]}], 
                  "}"}]}], ",", 
                RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], "]"}]}], 
             ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"UndirectedGraphQ", "[", "GGrafo", "]"}], ",", 
               RowBox[{"TableForm", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"VertexDegree", "[", "GGrafo", "]"}], "}"}], ",", 
                 RowBox[{"TableHeadings", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", "\"\<Grado o valencia\>\"", "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafo", "]"}]}]}], "}"}]}], 
                 ",", 
                 RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], "]"}], 
               ",", 
               RowBox[{"TableForm", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"VertexInDegree", "[", "GGrafo", "]"}], ",", 
                   RowBox[{"VertexOutDegree", "[", "GGrafo", "]"}]}], "}"}], 
                 ",", 
                 RowBox[{"TableHeadings", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Grado o valencia interna\>\"", ",", 
                    "\"\<Grado o valencia externa\>\""}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafo", "]"}]}]}], "}"}]}], 
                 ",", 
                 RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], "]"}]}], 
              "]"}]}], "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
             RowBox[{
              RowBox[{"GGrafoAuxiliar15", "=", 
               RowBox[{"CombinatoricaToGraph", "[", "GGrafo", "]"}]}], ";", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"UndirectedGraphQ", "[", "GGrafoAuxiliar15", "]"}], 
                ",", 
                RowBox[{"TableForm", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"VertexDegree", "[", "GGrafoAuxiliar15", "]"}], 
                   "}"}], ",", 
                  RowBox[{"TableHeadings", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", "\"\<Grado o valencia\>\"", "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar15", "]"}]}]}], 
                    "}"}]}], ",", 
                  RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], "]"}], 
                ",", 
                RowBox[{"TableForm", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"VertexInDegree", "[", "GGrafoAuxiliar15", "]"}], 
                    ",", 
                    RowBox[{
                    "VertexOutDegree", "[", "GGrafoAuxiliar15", "]"}]}], 
                   "}"}], ",", 
                  RowBox[{"TableHeadings", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Grado o valencia interna\>\"", ",", 
                    "\"\<Grado o valencia externa\>\""}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar15", "]"}]}]}], 
                    "}"}]}], ",", 
                  RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], "]"}]}],
                "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"CantNodos", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
           RowBox[{"VertexCount", "[", "GGrafo", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
             RowBox[{"V", "[", "GGrafo", "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
      ";", 
      RowBox[{
       RowBox[{"CantAristas", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"AristasMixtasQ", "[", "GGrafo", "]"}], ",", 
             RowBox[{"Length", "[", 
              RowBox[{"AristasMixtasWolframSystemToCombinatorica", "[", 
               RowBox[{"EdgeList", "[", "GGrafo", "]"}], "]"}], "]"}], ",", 
             RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
             RowBox[{"M", "[", "GGrafo", "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
      ";", 
      RowBox[{
       RowBox[{"Options", "[", "MGrafo", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{"table", "\[Rule]", "False"}], "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"MGrafo", "[", 
        RowBox[{"GGrafo_", ",", "GNodos_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "GGrafoAuxiliar3", "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"VectorQ", "[", "GNodos", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{"GNodos", ",", "Null"}], "]"}], "\[Equal]", "False"}], 
             ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"GNodos", "\[NotEqual]", 
                RowBox[{"{", "}"}]}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"BooleanQ", "[", 
                  RowBox[{"OptionValue", "[", "table", "]"}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "GGrafo", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"Sort", "[", "GNodos", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GGrafoAuxiliar3", "=", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{"GNodos", ",", 
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"OptionValue", "[", "table", "]"}]}], ",", 
                    RowBox[{"MatrixForm", "[", 
                    RowBox[{"AdjacencyMatrix", "[", "GGrafoAuxiliar3", "]"}], 
                    "]"}], ",", 
                    RowBox[{"TableForm", "[", 
                    RowBox[{
                    RowBox[{"Normal", "@", 
                    RowBox[{
                    "AdjacencyMatrix", "[", "GGrafoAuxiliar3", "]"}]}], ",", 
                    RowBox[{"TableHeadings", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar3", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar3", "]"}]}]}], 
                    "}"}]}], ",", 
                    RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], 
                    "]"}]}], "]"}]}]}], "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
                    RowBox[{
                    RowBox[{"GGrafoAuxiliar3", "=", 
                    RowBox[{"CombinatoricaToGraph", "[", "GGrafo", "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar3", "]"}], 
                    "]"}], "\[Equal]", 
                    RowBox[{"Sort", "[", "GNodos", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GGrafoAuxiliar3", "=", 
                    RowBox[{"Grafo", "[", 
                    RowBox[{
                    RowBox[{"Edges", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"vertices", "\[Rule]", "GNodos"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", 
                    RowBox[{"!", 
                    RowBox[{"UndirectedQ", "[", "GGrafo", "]"}]}]}]}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"OptionValue", "[", "table", "]"}]}], ",", 
                    RowBox[{"MatrixForm", "[", 
                    RowBox[{"AdjacencyMatrix", "[", "GGrafoAuxiliar3", "]"}], 
                    "]"}], ",", 
                    RowBox[{"TableForm", "[", 
                    RowBox[{
                    RowBox[{"Normal", "@", 
                    RowBox[{
                    "AdjacencyMatrix", "[", "GGrafoAuxiliar3", "]"}]}], ",", 
                    RowBox[{"TableHeadings", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar3", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar3", "]"}]}]}], 
                    "}"}]}], ",", 
                    RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], 
                    "]"}]}], "]"}]}]}], "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], 
              "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "MPGrafo", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{"table", "\[Rule]", "False"}], "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"MPGrafo", "[", 
        RowBox[{"GGrafo_", ",", "GNodos_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GGrafoAuxiliar7", ",", "GVl13"}], "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"VectorQ", "[", "GNodos", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{"GNodos", ",", "Null"}], "]"}], "\[Equal]", "False"}], 
             ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"GNodos", "\[NotEqual]", 
                RowBox[{"{", "}"}]}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"BooleanQ", "[", 
                  RowBox[{"OptionValue", "[", "table", "]"}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"PesosAristas", "[", "GGrafo", "]"}], "}"}], ",", 
                    "Null"}], "]"}], "\[Equal]", "False"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "GGrafo", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"Sort", "[", "GNodos", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"AristasMixtasQ", "[", "GGrafo", "]"}], ",", 
                    RowBox[{
                    RowBox[{"GGrafoAuxiliar7", "=", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{"GNodos", ",", 
                    RowBox[{"AristasCombinatoricaToWolframSystem", "[", 
                    RowBox[{
                    RowBox[{"AristasMixtasWolframSystemToCombinatorica", "[", 
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"GVl13", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GGrafo", "]"}], ",", "1"}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"EdgeQ", "[", 
                    RowBox[{"GGrafoAuxiliar7", ",", "#"}], "]"}], "\[Equal]", 
                    "False"}], "&"}]}], "]"}]}], ";", 
                    RowBox[{"GGrafoAuxiliar7", "=", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{"GNodos", ",", 
                    RowBox[{"EdgeList", "[", "GGrafoAuxiliar7", "]"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", "GVl13"}]}], 
                    "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl13", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GGrafo", "]"}], ",", "1"}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"EdgeQ", "[", 
                    RowBox[{"GGrafo", ",", "#"}], "]"}], "\[Equal]", 
                    "False"}], "&"}]}], "]"}]}], ";", 
                    RowBox[{"GGrafoAuxiliar7", "=", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{"GNodos", ",", 
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", "GVl13"}]}], 
                    "]"}]}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"OptionValue", "[", "table", "]"}]}], ",", 
                    RowBox[{"MatrixForm", "[", 
                    RowBox[{
                    "WeightedAdjacencyMatrix", "[", "GGrafoAuxiliar7", "]"}], 
                    "]"}], ",", 
                    RowBox[{"TableForm", "[", 
                    RowBox[{
                    RowBox[{"Normal", "@", 
                    RowBox[{
                    "WeightedAdjacencyMatrix", "[", "GGrafoAuxiliar7", 
                    "]"}]}], ",", 
                    RowBox[{"TableHeadings", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar7", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar7", "]"}]}]}], 
                    "}"}]}], ",", 
                    RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], 
                    "]"}]}], "]"}]}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
                    RowBox[{
                    RowBox[{"GVl13", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GGrafo", "]"}], ",", "1"}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", "#", "]"}], "\[Equal]", "False"}], 
                    "&"}]}], "]"}]}], ";", 
                    RowBox[{"GGrafoAuxiliar7", "=", 
                    RowBox[{"CombinatoricaToGraph", "[", "GGrafo", "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar7", "]"}], 
                    "]"}], "\[Equal]", 
                    RowBox[{"Sort", "[", "GNodos", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GGrafoAuxiliar7", "=", 
                    RowBox[{"Grafo", "[", 
                    RowBox[{
                    RowBox[{"Edges", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"vertices", "\[Rule]", "GNodos"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", 
                    RowBox[{"!", 
                    RowBox[{"UndirectedQ", "[", "GGrafo", "]"}]}]}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl13"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"OptionValue", "[", "table", "]"}]}], ",", 
                    RowBox[{"MatrixForm", "[", 
                    RowBox[{
                    "WeightedAdjacencyMatrix", "[", "GGrafoAuxiliar7", "]"}], 
                    "]"}], ",", 
                    RowBox[{"TableForm", "[", 
                    RowBox[{
                    RowBox[{"Normal", "@", 
                    RowBox[{
                    "WeightedAdjacencyMatrix", "[", "GGrafoAuxiliar7", 
                    "]"}]}], ",", 
                    RowBox[{"TableHeadings", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar7", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar7", "]"}]}]}], 
                    "}"}]}], ",", 
                    RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], 
                    "]"}]}], "]"}]}]}], "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], 
                "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "GrafoMI", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
         RowBox[{"shape", "\[Rule]", "False"}]}], "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"GrafoMI", "[", 
        RowBox[{"GMatriz_", ",", "GVertices_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "GrafoSinVertexLabels", ",", "ValidacionIndicenceQ", ",", 
           "TransMatrizIncidence", ",", "GGrafoAuxiliar8"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"GrafoSinVertexLabels", "[", "GrafoVertexLabels_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "VariableOpciones", ",", "VariablePosicion", ",", 
               "VariableParametroi", ",", "VectorAuxiliarLabels", ",", 
               "GrafoSinLabels"}], "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"GraphQ", "[", "GrafoVertexLabels", "]"}], ",", 
               RowBox[{
                RowBox[{"VariableOpciones", "=", 
                 RowBox[{"Options", "[", "GrafoVertexLabels", "]"}]}], ";", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"StringContainsQ", "[", 
                   RowBox[{
                    RowBox[{"ToString", "[", "VariableOpciones", "]"}], ",", 
                    "\"\<VertexLabels\>\""}], "]"}], ",", 
                  RowBox[{
                   RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"VariableParametroi", "=", "1"}], ",", 
                    RowBox[{"VariableParametroi", "\[LessEqual]", 
                    RowBox[{"Length", "[", "VariableOpciones", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"VariableOpciones", "[", 
                    RowBox[{"[", "VariableParametroi", "]"}], "]"}], "]"}], 
                    ",", "\"\<VertexLabels\>\""}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"VariablePosicion", "=", "VariableParametroi"}], 
                    ";", 
                    RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"VariableParametroi", "++"}]}]}], "]"}], ";", 
                   RowBox[{"VectorAuxiliarLabels", "=", 
                    RowBox[{
                    RowBox[{"VariableOpciones", "[", 
                    RowBox[{"[", "VariablePosicion", "]"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ";", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", "VectorAuxiliarLabels", "]"}], 
                    ",", "\"\<Name\>\""}], "]"}], ",", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"VariableParametroi", "=", "1"}], ",", 
                    RowBox[{"VariableParametroi", "\[LessEqual]", 
                    RowBox[{"Length", "[", "VectorAuxiliarLabels", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorAuxiliarLabels", "[", 
                    RowBox[{"[", "VariableParametroi", "]"}], "]"}], 
                    "\[Equal]", "\"\<Name\>\""}], ",", 
                    RowBox[{"VectorAuxiliarLabels", "=", 
                    RowBox[{"Delete", "[", 
                    RowBox[{
                    "VectorAuxiliarLabels", ",", "VariableParametroi"}], 
                    "]"}]}]}], "]"}], ";", 
                    RowBox[{"VariableParametroi", "++"}]}]}], "]"}]}], "]"}], 
                   ";", 
                   RowBox[{"GrafoSinLabels", "=", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{
                    RowBox[{"VertexList", "[", "GrafoVertexLabels", "]"}], "/.",
                     "VectorAuxiliarLabels"}], "]"}], ",", 
                    RowBox[{"Sort", "[", 
                    RowBox[{
                    RowBox[{"EdgeList", "[", "GrafoVertexLabels", "]"}], "/.",
                     "VectorAuxiliarLabels"}], "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], ";",
                    "GrafoSinLabels"}], ",", 
                  RowBox[{
                   RowBox[{"GrafoSinLabels", "=", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "GrafoVertexLabels", "]"}], 
                    "]"}], ",", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"EdgeList", "[", "GrafoVertexLabels", "]"}], 
                    "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], ";",
                    "GrafoSinLabels"}]}], "]"}]}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"ValidacionIndicenceQ", "[", "GGMatriz_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"GVl14", "=", "True"}], ",", "GVl15", ",", "GVl16"}], 
              "}"}], ",", 
             RowBox[{
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"Gi11", "=", "1"}], ",", 
                RowBox[{"Gi11", "\[LessEqual]", 
                 RowBox[{
                  RowBox[{"Dimensions", "[", "GGMatriz", "]"}], "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"GVl15", "=", 
                  RowBox[{"Count", "[", 
                   RowBox[{
                    RowBox[{"GGMatriz", "[", 
                    RowBox[{"[", 
                    RowBox[{"All", ",", "Gi11"}], "]"}], "]"}], ",", "1"}], 
                   "]"}]}], ";", 
                 RowBox[{"GVl16", "=", 
                  RowBox[{"Count", "[", 
                   RowBox[{
                    RowBox[{"GGMatriz", "[", 
                    RowBox[{"[", 
                    RowBox[{"All", ",", "Gi11"}], "]"}], "]"}], ",", 
                    RowBox[{"-", "1"}]}], "]"}]}], ";", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"GVl15", "\[NotEqual]", "1"}], "||", 
                    RowBox[{"GVl16", "\[NotEqual]", "1"}]}], ")"}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"GVl15", "\[NotEqual]", "1"}], "||", 
                    RowBox[{"GVl16", "\[NotEqual]", "0"}]}], ")"}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"GVl15", "\[NotEqual]", "2"}], "||", 
                    RowBox[{"GVl16", "\[NotEqual]", "0"}]}], ")"}]}], ",", 
                   RowBox[{
                    RowBox[{"GVl14", "=", "False"}], ";", 
                    RowBox[{"Break", "[", "]"}]}]}], "]"}], ";", 
                 RowBox[{"Gi11", "++"}]}]}], "]"}], ";", "GVl14"}]}], "]"}]}],
           ";", 
          RowBox[{
           RowBox[{"TransMatrizIncidence", "[", "GGMatriz_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"GMatriz1", "=", "GGMatriz"}], "}"}], ",", 
             RowBox[{
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"Gi12", "=", "1"}], ",", 
                RowBox[{"Gi12", "\[LessEqual]", 
                 RowBox[{
                  RowBox[{"Dimensions", "[", "GMatriz1", "]"}], "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"Count", "[", 
                    RowBox[{
                    RowBox[{"GMatriz1", "[", 
                    RowBox[{"[", 
                    RowBox[{"All", ",", "Gi12"}], "]"}], "]"}], ",", "1"}], 
                    "]"}], "+", 
                    RowBox[{"Count", "[", 
                    RowBox[{
                    RowBox[{"GMatriz1", "[", 
                    RowBox[{"[", 
                    RowBox[{"All", ",", "Gi12"}], "]"}], "]"}], ",", 
                    RowBox[{"-", "1"}]}], "]"}]}], "\[Equal]", "1"}], ",", 
                   RowBox[{
                    RowBox[{"GMatriz1", "[", 
                    RowBox[{"[", 
                    RowBox[{"All", ",", "Gi12"}], "]"}], "]"}], "=", 
                    RowBox[{"Replace", "[", 
                    RowBox[{
                    RowBox[{"GMatriz1", "[", 
                    RowBox[{"[", 
                    RowBox[{"All", ",", "Gi12"}], "]"}], "]"}], ",", 
                    RowBox[{"1", "\[Rule]", "2"}], ",", "2"}], "]"}]}]}], 
                  "]"}], ";", 
                 RowBox[{"Gi12", "++"}]}]}], "]"}], ";", "GMatriz1"}]}], 
            "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "dimensions3d", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "shape", "]"}], "]"}]}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"MatrixQ", "[", 
                RowBox[{"GMatriz", ",", "IntegerQ"}], "]"}], "&&", 
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{
                  RowBox[{"Flatten", "[", "GMatriz", "]"}], ",", "Null"}], 
                 "]"}], "\[Equal]", "False"}]}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"MemberQ", "[", 
                  RowBox[{
                   RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"ToString", "[", "GMatriz", "]"}], "]"}], ",", 
                   "62760"}], "]"}], "\[Equal]", "False"}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"MBooleanQ", "[", 
                   RowBox[{"Abs", "[", 
                    RowBox[{"Normal", "[", "GMatriz", "]"}], "]"}], "]"}], 
                  ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"ValidacionIndicenceQ", "[", 
                    RowBox[{"Normal", "[", "GMatriz", "]"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VectorQ", "[", "GVertices", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"GVertices", ",", "Null"}], "]"}], "\[Equal]", 
                    "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GVertices", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "GVertices", "]"}], "\[Equal]", 
                    RowBox[{"Length", "[", 
                    RowBox[{"DeleteDuplicates", "[", "GVertices", "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "GMatriz", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", 
                    RowBox[{"Length", "[", "GVertices", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "GVertices", "]"}], 
                    "\[NotEqual]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi6", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi6", ",", 
                    RowBox[{"Length", "[", "GVertices", "]"}]}], "}"}]}], 
                    "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GGrafoAuxiliar8", "=", 
                    RowBox[{"IncidenceGraph", "[", 
                    RowBox[{
                    RowBox[{"TransMatrizIncidence", "[", 
                    RowBox[{"Normal", "[", "GMatriz", "]"}], "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Gi6", "->", 
                    RowBox[{"GVertices", "[", 
                    RowBox[{"[", "Gi6", "]"}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi6", ",", 
                    RowBox[{"Length", "[", "GVertices", "]"}]}], "}"}]}], 
                    "]"}]}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], ";", 
                    RowBox[{"GGrafoAuxiliar8", "=", 
                    RowBox[{"GrafoSinVertexLabels", "[", "GGrafoAuxiliar8", 
                    "]"}]}]}], ",", 
                    RowBox[{"GGrafoAuxiliar8", "=", 
                    RowBox[{"IncidenceGraph", "[", 
                    RowBox[{
                    RowBox[{"TransMatrizIncidence", "[", 
                    RowBox[{"Normal", "[", "GMatriz", "]"}], "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "dimensions3d", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], ",", 
                    RowBox[{"System`Graph3D", "[", 
                    RowBox[{
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar8", "]"}], ",", 
                    RowBox[{"EdgeList", "[", "GGrafoAuxiliar8", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}], ",", 
                    RowBox[{"System`Graph3D", "[", 
                    RowBox[{
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar8", "]"}], ",", 
                    RowBox[{"EdgeList", "[", "GGrafoAuxiliar8", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], 
                    "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "shape", "]"}], ",", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar8", "]"}], ",", 
                    RowBox[{"EdgeList", "[", "GGrafoAuxiliar8", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}], ",", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar8", "]"}], ",", 
                    RowBox[{"EdgeList", "[", "GGrafoAuxiliar8", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], 
                    "]"}]}], "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{"MBooleanQ", "[", "MatrizSBooleana_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MatrixQ", "[", 
          RowBox[{"MatrizSBooleana", ",", "NumericQ"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"Flatten", "[", "MatrizSBooleana", "]"}], ",", "Null"}],
              "]"}], "\[Equal]", "False"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MatrizSBooleana", "^", "2"}], "==", 
              "MatrizSBooleana"}], ",", "True", ",", "False"}], "]"}], ",", 
           "False"}], "]"}], ",", "False"}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"ResaltarRuta", "[", 
        RowBox[{"GGrafo_", ",", "GLista_"}], "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MatrixQ", "[", "GLista", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"Flatten", "[", "GLista", "]"}], ",", "Null"}], "]"}], 
            "\[Equal]", "False"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{
                RowBox[{"ToCharacterCode", "[", 
                 RowBox[{"ToString", "[", "GLista", "]"}], "]"}], ",", 
                "62760"}], "]"}], "\[Equal]", "False"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"Dimensions", "[", "GLista", "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"AristasMixtasQ", "[", "GGrafo", "]"}], ",", 
                   RowBox[{
                    RowBox[{"GGrafoAuxiliar16", "=", 
                    RowBox[{"Grafo", "[", 
                    RowBox[{
                    RowBox[{"AristasMixtasWolframSystemToCombinatorica", "[", 
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"VertexList", "[", "GGrafo", "]"}]}]}], "]"}]}], 
                    ";", 
                    RowBox[{"GList11", "=", 
                    RowBox[{"AristasCombinatoricaToWolframSystem", "[", 
                    RowBox[{"GLista", ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}]}], "]"}]}], ";", 
                    RowBox[{"HighlightGraph", "[", 
                    RowBox[{"GGrafoAuxiliar16", ",", "GList11", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{
                    "GraphHighlightStyle", "\[Rule]", "\"\<Thick\>\""}]}], 
                    "]"}]}], ",", 
                   RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"UndirectedGraphQ", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"GList11", "=", 
                    RowBox[{
                    "AristasCombinatoricaToWolframSystem", "[", "GLista", 
                    "]"}]}], ",", 
                    RowBox[{"GList11", "=", 
                    RowBox[{"AristasCombinatoricaToWolframSystem", "[", 
                    RowBox[{"GLista", ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}]}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"HighlightGraph", "[", 
                    RowBox[{"GGrafo", ",", "GList11", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{
                    "GraphHighlightStyle", "\[Rule]", "\"\<Thick\>\""}]}], 
                    "]"}]}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
                   RowBox[{
                    RowBox[{"GGrafoAuxiliar16", "=", 
                    RowBox[{"CombinatoricaToGraph", "[", "GGrafo", "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "UndirectedGraphQ", "[", "GGrafoAuxiliar16", "]"}], ",", 
                    RowBox[{"GList11", "=", 
                    RowBox[{
                    "AristasCombinatoricaToWolframSystem", "[", "GLista", 
                    "]"}]}], ",", 
                    RowBox[{"GList11", "=", 
                    RowBox[{"AristasCombinatoricaToWolframSystem", "[", 
                    RowBox[{"GLista", ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}]}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"HighlightGraph", "[", 
                    RowBox[{"GGrafoAuxiliar16", ",", "GList11", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{
                    "GraphHighlightStyle", "\[Rule]", "\"\<Thick\>\""}]}], 
                    "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "CombinatoricaToGraph", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
         RowBox[{"mostrarpesos", "\[Rule]", "False"}], ",", 
         RowBox[{"shape", "\[Rule]", "False"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CombinatoricaToGraph", "[", 
        RowBox[{"GGrafo_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GrafoO3d", ",", "GrafoONo3d"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"GrafoO3d", "[", "GOGrafo_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl2", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"UndirectedQ", "[", "GOGrafo", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl2", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}],
                     "&"}]}], "]"}]}], ";", 
                  RowBox[{"Grafo", "[", 
                   RowBox[{
                    RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                 ",", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{
                   RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                   RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                   RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                   ",", 
                   RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
                   RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                   RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl2", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}],
                     "&"}]}], "]"}]}], ";", 
                  RowBox[{"Grafo", "[", 
                   RowBox[{
                    RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                 ",", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{
                   RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                   RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                   RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                   ",", 
                   RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
                   RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                   RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"GrafoONo3d", "[", "GOGrafo_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl2", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"UndirectedQ", "[", "GOGrafo", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl2", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}],
                     "&"}]}], "]"}]}], ";", 
                  RowBox[{"Grafo", "[", 
                   RowBox[{
                    RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                 ",", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{
                   RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                   RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                   RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                   ",", 
                   RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
                   RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                   RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl2", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}],
                     "&"}]}], "]"}]}], ";", 
                  RowBox[{"Grafo", "[", 
                   RowBox[{
                    RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                 ",", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{
                   RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                   RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                   RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                   ",", 
                   RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
                   RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                   RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "dimensions3d", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "shape", "]"}], "]"}]}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"OptionValue", "[", "dimensions3d", "]"}], ",", 
                RowBox[{"GrafoO3d", "[", "GGrafo", "]"}], ",", 
                RowBox[{"GrafoONo3d", "[", "GGrafo", "]"}]}], "]"}]}], 
             "]"}]}], "]"}]}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "MIGrafo", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"edgesgraph", "\[Rule]", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"table", "\[Rule]", "False"}]}], "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"MIGrafo", "[", 
        RowBox[{"GGrafo_", ",", "GNodos_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GGrafoAuxiliar9", ",", "GMatriz2", ",", 
           RowBox[{"GVl17", "=", "True"}]}], "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"VectorQ", "[", "GNodos", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{"GNodos", ",", "Null"}], "]"}], "\[Equal]", "False"}], 
             ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"GNodos", "\[NotEqual]", 
                RowBox[{"{", "}"}]}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"BooleanQ", "[", 
                  RowBox[{"OptionValue", "[", "table", "]"}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"MatrixQ", "[", 
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], "]"}], "||", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], 
                    "\[Equal]", 
                    RowBox[{"{", "}"}]}]}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], "]"}], 
                    "]"}], ",", "62760"}], "]"}], "\[Equal]", "False"}], "||", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], 
                    "\[Equal]", 
                    RowBox[{"{", "}"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], 
                    "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", 
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], "]"}], 
                    "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[NotEqual]", "2"}], ",", 
                    RowBox[{"GVl17", "=", "False"}]}], "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"GVl17", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], "]"}], 
                    ",", "Null"}], "]"}], "\[Equal]", "False"}], "||", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], 
                    "\[Equal]", 
                    RowBox[{"{", "}"}]}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"AristasMixtasQ", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"AristasMixtasWolframSystemToCombinatorica", "[", 
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "]"}], "]"}]}], 
                    "||", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], 
                    "\[Equal]", 
                    RowBox[{"{", "}"}]}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "GGrafo", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"Sort", "[", "GNodos", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], 
                    "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"GGrafoAuxiliar9", "=", 
                    RowBox[{"Grafo", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], ",", 
                    RowBox[{"vertices", "\[Rule]", "GNodos"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}]}], "]"}]}], ",", 
                    RowBox[{"GGrafoAuxiliar9", "=", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{"GNodos", ",", 
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}]}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"OptionValue", "[", "table", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GMatriz2", "=", 
                    RowBox[{"Normal", "[", 
                    RowBox[{
                    "System`IncidenceMatrix", "[", "GGrafoAuxiliar9", "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"GMatriz2", "=", 
                    RowBox[{"Replace", "[", 
                    RowBox[{"GMatriz2", ",", 
                    RowBox[{"2", "\[Rule]", "1"}], ",", "2"}], "]"}]}], ";", 
                    RowBox[{"MatrixForm", "[", "GMatriz2", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GMatriz2", "=", 
                    RowBox[{"Normal", "[", 
                    RowBox[{
                    "System`IncidenceMatrix", "[", "GGrafoAuxiliar9", "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"GMatriz2", "=", 
                    RowBox[{"Replace", "[", 
                    RowBox[{"GMatriz2", ",", 
                    RowBox[{"2", "\[Rule]", "1"}], ",", "2"}], "]"}]}], ";", 
                    RowBox[{"MatrixForm", "[", "GMatriz2", "]"}], ";", 
                    RowBox[{"TableForm", "[", 
                    RowBox[{"GMatriz2", ",", 
                    RowBox[{"TableHeadings", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar9", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"EdgeList", "[", "GGrafoAuxiliar9", "]"}]}]}], 
                    "}"}]}], ",", 
                    RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "]"}], "]"}]}], 
                    "||", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], 
                    "\[Equal]", 
                    RowBox[{"{", "}"}]}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "GGrafo", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"Sort", "[", "GNodos", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], 
                    "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"GGrafoAuxiliar9", "=", 
                    RowBox[{"Grafo", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], ",", 
                    RowBox[{"vertices", "\[Rule]", "GNodos"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", 
                    RowBox[{"!", 
                    RowBox[{"UndirectedGraphQ", "[", "GGrafo", "]"}]}]}]}], 
                    "]"}]}], ",", 
                    RowBox[{"GGrafoAuxiliar9", "=", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{"GNodos", ",", 
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}]}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"OptionValue", "[", "table", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GMatriz2", "=", 
                    RowBox[{"Normal", "[", 
                    RowBox[{
                    "System`IncidenceMatrix", "[", "GGrafoAuxiliar9", "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"GMatriz2", "=", 
                    RowBox[{"Replace", "[", 
                    RowBox[{"GMatriz2", ",", 
                    RowBox[{"2", "\[Rule]", "1"}], ",", "2"}], "]"}]}], ";", 
                    RowBox[{"MatrixForm", "[", "GMatriz2", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GMatriz2", "=", 
                    RowBox[{"Normal", "[", 
                    RowBox[{
                    "System`IncidenceMatrix", "[", "GGrafoAuxiliar9", "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"GMatriz2", "=", 
                    RowBox[{"Replace", "[", 
                    RowBox[{"GMatriz2", ",", 
                    RowBox[{"2", "\[Rule]", "1"}], ",", "2"}], "]"}]}], ";", 
                    RowBox[{"MatrixForm", "[", "GMatriz2", "]"}], ";", 
                    RowBox[{"TableForm", "[", 
                    RowBox[{"GMatriz2", ",", 
                    RowBox[{"TableHeadings", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar9", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"EdgeList", "[", "GGrafoAuxiliar9", "]"}]}]}], 
                    "}"}]}], ",", 
                    RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
                    RowBox[{
                    RowBox[{"GGrafoAuxiliar9", "=", 
                    RowBox[{"CombinatoricaToGraph", "[", "GGrafo", "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafoAuxiliar9", "]"}], 
                    "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                    RowBox[{"EdgeList", "[", "GGrafoAuxiliar9", "]"}], "]"}], 
                    "]"}]}], "||", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], 
                    "\[Equal]", 
                    RowBox[{"{", "}"}]}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar9", "]"}], 
                    "]"}], "\[Equal]", 
                    RowBox[{"Sort", "[", "GNodos", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], 
                    "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"GGrafoAuxiliar9", "=", 
                    RowBox[{"Grafo", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "edgesgraph", "]"}], ",", 
                    RowBox[{"vertices", "\[Rule]", "GNodos"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", 
                    RowBox[{"!", 
                    RowBox[{"UndirectedQ", "[", "GGrafo", "]"}]}]}]}], 
                    "]"}]}], ",", 
                    RowBox[{"GGrafoAuxiliar9", "=", 
                    RowBox[{"Grafo", "[", 
                    RowBox[{
                    RowBox[{"Edges", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"vertices", "\[Rule]", "GNodos"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", 
                    RowBox[{"!", 
                    RowBox[{"UndirectedQ", "[", "GGrafo", "]"}]}]}]}], 
                    "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"OptionValue", "[", "table", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GMatriz2", "=", 
                    RowBox[{"Normal", "[", 
                    RowBox[{
                    "System`IncidenceMatrix", "[", "GGrafoAuxiliar9", "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"GMatriz2", "=", 
                    RowBox[{"Replace", "[", 
                    RowBox[{"GMatriz2", ",", 
                    RowBox[{"2", "\[Rule]", "1"}], ",", "2"}], "]"}]}], ";", 
                    RowBox[{"MatrixForm", "[", "GMatriz2", "]"}], ";", 
                    RowBox[{"MatrixForm", "[", "GMatriz2", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GMatriz2", "=", 
                    RowBox[{"Normal", "[", 
                    RowBox[{
                    "System`IncidenceMatrix", "[", "GGrafoAuxiliar9", "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"GMatriz2", "=", 
                    RowBox[{"Replace", "[", 
                    RowBox[{"GMatriz2", ",", 
                    RowBox[{"2", "\[Rule]", "1"}], ",", "2"}], "]"}]}], ";", 
                    RowBox[{"MatrixForm", "[", "GMatriz2", "]"}], ";", 
                    RowBox[{"TableForm", "[", 
                    RowBox[{"GMatriz2", ",", 
                    RowBox[{"TableHeadings", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar9", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"EdgeList", "[", "GGrafoAuxiliar9", "]"}]}]}], 
                    "}"}]}], ",", 
                    RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}], "]"}]}], "]"}]}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], "]"}]}], 
                "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"GrafoPonderadoNQ", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GrafoPonderadoQ", "[", "GGrafo", "]"}], ",", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"AristasMixtasQ", "[", "GGrafo", "]"}], ",", 
              RowBox[{"GGrafoAuxiliar36", "=", 
               RowBox[{"Grafo", "[", 
                RowBox[{
                 RowBox[{"AristasMixtasWolframSystemToCombinatorica", "[", 
                  RowBox[{"EdgeList", "[", "GGrafo", "]"}], "]"}], ",", 
                 RowBox[{"dirigido", "\[Rule]", "True"}]}], "]"}]}], ",", 
              RowBox[{"GGrafoAuxiliar36", "=", "GGrafo"}]}], "]"}], ";", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"VectorQ", "[", 
               RowBox[{
                RowBox[{"Select", "[", 
                 RowBox[{
                  RowBox[{"Flatten", "[", 
                   RowBox[{"PesosAristas", "[", "GGrafo", "]"}], "]"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"EdgeQ", "[", 
                    RowBox[{"GGrafoAuxiliar36", ",", "#"}], "]"}], "\[Equal]",
                     "False"}], "&"}]}], "]"}], ",", "NumericQ"}], "]"}], ",",
               "True", ",", "False"}], "]"}]}], ",", "False"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"GrafoPonderadoQ", "[", "GGrafo", "]"}], ",", 
             RowBox[{
              RowBox[{"GGrafoAuxiliar36", "=", 
               RowBox[{"CombinatoricaToGraph", "[", "GGrafo", "]"}]}], ";", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"VectorQ", "[", 
                 RowBox[{
                  RowBox[{"Select", "[", 
                   RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{"PesosAristas", "[", "GGrafoAuxiliar36", "]"}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"EdgeQ", "[", 
                    RowBox[{"GGrafoAuxiliar36", ",", "#"}], "]"}], "\[Equal]",
                     "False"}], "&"}]}], "]"}], ",", "NumericQ"}], "]"}], ",",
                 "True", ",", "False"}], "]"}]}], ",", "False"}], "]"}]}], 
          "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"GrafoPonderadoQ", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"!", 
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"PesosAristas", "[", "GGrafo", "]"}], "}"}], ",", 
              "Null"}], "]"}]}], ",", "True", ",", "False"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"!", 
              RowBox[{"MemberQ", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"PesosAristas", "[", "GGrafo", "]"}], "}"}], ",", 
                "Null"}], "]"}]}], ",", "True", ",", "False"}], "]"}]}], 
          "]"}]}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Column", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Spacer", "[", 
             RowBox[{"{", 
              RowBox[{"400", ",", "2"}], "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Autor: Enrique V\[IAcute]lchez Quesada\>\"", ",", "Bold", 
                ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}], 
              "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica\>\"", ",", "Bold", ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.12", ",", "0", ",", "0.5"}], "]"}]}], "]"}], 
              "}"}], "]"}]}], "}"}], ",", "Center"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Grafos\>\"", ",", " ", "Bold", ",", " ", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}]}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.670161677071475*^9, 3.670161729000079*^9, 3.670161763950135*^9, 
   3.6701618168457837`*^9, 3.670161859572769*^9, 3.670161930114304*^9, 
   3.6701619842213593`*^9, {3.670162738495474*^9, 3.670162875497634*^9}, {
   3.6701629647165117`*^9, 3.6701630286018496`*^9}, {3.6701630765669527`*^9, 
   3.6701630769677563`*^9}, 3.6701631346799374`*^9, {3.670163461174367*^9, 
   3.6701634615948973`*^9}, {3.670163556476186*^9, 3.6701635766052437`*^9}, {
   3.6701636207494826`*^9, 3.670163755924075*^9}, {3.6701637895343666`*^9, 
   3.670163804042716*^9}, {3.670163919696806*^9, 3.67016392085505*^9}, {
   3.670164057631043*^9, 3.670164122053164*^9}, {3.6701647677713614`*^9, 
   3.6701647716149282`*^9}, {3.670165313255272*^9, 3.6701653156599927`*^9}, {
   3.67855695150906*^9, 3.6785570413826494`*^9}, {3.6785572151071835`*^9, 
   3.6785572239750185`*^9}, 3.6785573242303886`*^9, {3.801155758657878*^9, 
   3.8011557730549335`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"42d06299-c361-47df-9a73-6a8f9bea65d5"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`GVl20$$ = {$CellContext`a, $CellContext`b, \
$CellContext`c}, $CellContext`GVl21$$ = {{$CellContext`a, $CellContext`b}, \
{$CellContext`b, $CellContext`c}}, $CellContext`GVl22$$ = {1, 
    1}, $CellContext`GVl23$$ = 
    False, $CellContext`GVl24$$ = $CellContext`a, $CellContext`GVl25$$ = \
$CellContext`c, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[
       Style["Elementos del grafo", Bold, Medium]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`GVl20$$], {$CellContext`a, $CellContext`b, \
$CellContext`c}, "V\[EAcute]rtices"}}, {{
       Hold[$CellContext`GVl21$$], {{$CellContext`a, $CellContext`b}, \
{$CellContext`b, $CellContext`c}}, "Aristas"}}, {
      Hold[
       Style["Grafo ponderado", Bold, Medium]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`GVl22$$], {1, 1}, "Pesos de las aristas"}}, {
      Hold[
       Style["Grafo dirigido", Bold, Medium]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`GVl23$$], False, "Digrafo"}, {True, False}}, {
      Hold[
       Style[
       "Nodos para la ruta del camino m\[AAcute]s corto", Bold, Medium]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`GVl24$$], $CellContext`a, "Nodo 1"}}, {{
       Hold[$CellContext`GVl25$$], $CellContext`c, "Nodo 2"}}}, 
    Typeset`size$$ = {510., {312., 321.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`GVl20$$ = {$CellContext`a, $CellContext`b, \
$CellContext`c}, $CellContext`GVl21$$ = {{$CellContext`a, $CellContext`b}, \
{$CellContext`b, $CellContext`c}}, $CellContext`GVl22$$ = {1, 
         1}, $CellContext`GVl23$$ = 
        False, $CellContext`GVl24$$ = $CellContext`a, $CellContext`GVl25$$ = \
$CellContext`c}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> If[
        VectorQ[$CellContext`GVl20$$], 
        If[MemberQ[$CellContext`GVl20$$, Null] == False, 
         If[$CellContext`GVl20$$ != {}, 
          If[
           MatrixQ[$CellContext`GVl21$$], 
           If[MemberQ[
              ToCharacterCode[
               ToString[$CellContext`GVl21$$]], 62760] == False, 
            If[Part[
               Dimensions[$CellContext`GVl21$$], 2] == 2, 
             If[MemberQ[
                Flatten[$CellContext`GVl21$$], Null] == False, 
              If[
               VectorQ[$CellContext`GVl22$$], 
               If[MemberQ[$CellContext`GVl22$$, Null] == False, 
                If[$CellContext`GVl22$$ != {}, 
                 If[
                 Length[$CellContext`GVl22$$] == Length[$CellContext`GVl21$$], 
                  If[
                   And[
                    MemberQ[$CellContext`GVl20$$, $CellContext`GVl24$$], 
                    MemberQ[$CellContext`GVl20$$, $CellContext`GVl25$$]], 
                   
                   Column[{$CellContext`GGrafoAuxiliar17 = \
$CellContext`Grafo[$CellContext`GVl21$$, $CellContext`vertices -> \
$CellContext`GVl20$$, $CellContext`dirigido -> $CellContext`GVl23$$, \
$CellContext`pesos -> $CellContext`GVl22$$, $CellContext`mostrarpesos -> 
                    True], 
                    $CellContext`Valencias[$CellContext`GGrafoAuxiliar17], 
                    Row[{"Cantidad de v\[EAcute]rtices: ", 
                    $CellContext`CantNodos[$CellContext`GGrafoAuxiliar17]}], 
                    Row[{"Cantidad de aristas: ", 
                    $CellContext`CantAristas[$CellContext`GGrafoAuxiliar17]}], 
                    Row[{"Grafo conexo: ", 
                    ConnectedGraphQ[$CellContext`GGrafoAuxiliar17]}], 
                    Row[{"Matriz de adjacencia: ", 
                    $CellContext`MGrafo[$CellContext`GGrafoAuxiliar17, 
                    
                    VertexList[$CellContext`GGrafoAuxiliar17], \
$CellContext`table -> True]}], 
                    Row[{"Matriz de adjacencia de pesos: ", 
                    $CellContext`MPGrafo[$CellContext`GGrafoAuxiliar17, 
                    
                    VertexList[$CellContext`GGrafoAuxiliar17], \
$CellContext`table -> True]}], 
                    Row[{"Matriz de inicidencia: ", 
                    $CellContext`MIGrafo[$CellContext`GGrafoAuxiliar17, 
                    
                    VertexList[$CellContext`GGrafoAuxiliar17], \
$CellContext`table -> True]}], 
                    Row[{"Circuito de Euler: ", 
                    FindEulerianCycle[$CellContext`GGrafoAuxiliar17]}], 
                    Row[{"Circuito de Hamilton: ", 
                    FindHamiltonianCycle[$CellContext`GGrafoAuxiliar17]}], 
                    Row[{"Ruta de longitud m\[AAcute]s corta: ", 
                    If[
                    $CellContext`GrafoPonderadoNQ[$CellContext`\
GGrafoAuxiliar17], 
                    
                    FindShortestPath[$CellContext`GGrafoAuxiliar17, \
$CellContext`GVl24$$, $CellContext`GVl25$$], ""]}], 
                    If[
                    $CellContext`GrafoPonderadoNQ[$CellContext`\
GGrafoAuxiliar17], 
                    If[
                    FindShortestPath[$CellContext`GGrafoAuxiliar17, \
$CellContext`GVl24$$, $CellContext`GVl25$$] != {}, 
                    $CellContext`ResaltarRuta[$CellContext`GGrafoAuxiliar17, 
                    Partition[
                    
                    FindShortestPath[$CellContext`GGrafoAuxiliar17, \
$CellContext`GVl24$$, $CellContext`GVl25$$], 2, 1]], ""], ""]}], ""], ""], 
                 ""], ""], ""], ""], ""], ""], ""], ""], ""], ""], 
      "Specifications" :> {
        Style[
        "Elementos del grafo", Bold, 
         Medium], {{$CellContext`GVl20$$, {$CellContext`a, $CellContext`b, \
$CellContext`c}, 
          "V\[EAcute]rtices"}}, {{$CellContext`GVl21$$, {{$CellContext`a, \
$CellContext`b}, {$CellContext`b, $CellContext`c}}, "Aristas"}}, Delimiter, 
        Style[
        "Grafo ponderado", Bold, 
         Medium], {{$CellContext`GVl22$$, {1, 1}, "Pesos de las aristas"}}, 
        Delimiter, 
        Style[
        "Grafo dirigido", Bold, 
         Medium], {{$CellContext`GVl23$$, False, "Digrafo"}, {True, False}}, 
        Delimiter, 
        Style[
        "Nodos para la ruta del camino m\[AAcute]s corto", Bold, 
         Medium], {{$CellContext`GVl24$$, $CellContext`a, 
          "Nodo 1"}}, {{$CellContext`GVl25$$, $CellContext`c, "Nodo 2"}}}, 
      "Options" :> {Alignment -> Center, FrameLabel -> {{None, None}, {
           Column[{
             Spacer[{400, 2}], 
             Row[{
               Style["Autor: Enrique V\[IAcute]lchez Quesada", Bold, 10, 
                RGBColor[0, 0.333333, 0]]}], 
             Row[{
               Style[
               "Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica", Bold, 10, 
                RGBColor[0.12, 0, 0.5]]}]}, Center], 
           Style["Grafos", Bold, 
            RGBColor[0, 0.333333, 0]]}}}, "DefaultOptions" :> {}],
     ImageSizeCache->{1057., {407., 416.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>((
      Clear[$CellContext`a, $CellContext`b, $CellContext`c]; \
$CellContext`AristasWolframSystemToCombinatorica[
         Pattern[$CellContext`GAristasGrafo, 
          Blank[]]] := 
       Module[{$CellContext`GGrafoAuxiliar1 = 
          Graph[$CellContext`GAristasGrafo]}, 
         If[
          GraphQ[$CellContext`GGrafoAuxiliar1], 
          Quiet[
           Cases[$CellContext`GAristasGrafo, Pattern[$CellContext`Gicontador1, 
              Blank[]] -> {
              Part[$CellContext`Gicontador1, 1], 
              Part[$CellContext`Gicontador1, 2]}]]]]; 
      Options[$CellContext`AristasCombinatoricaToWolframSystem] = \
{$CellContext`dirigido -> 
         False}; $CellContext`AristasCombinatoricaToWolframSystem[
         Pattern[$CellContext`GAristasGrafo, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GAristasNoDirigidas, \
$CellContext`GAristasDirigidas}, $CellContext`GAristasNoDirigidas[
            Pattern[$CellContext`GOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`GOAritas, Pattern[$CellContext`Gicontador2, 
               Blank[]] -> UndirectedEdge[
               Part[$CellContext`Gicontador2, 1], 
               
               Part[$CellContext`Gicontador2, 
                2]]]]; $CellContext`GAristasDirigidas[
            Pattern[$CellContext`GOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`GOAritas, Pattern[$CellContext`Gicontador3, 
               Blank[]] -> DirectedEdge[
               Part[$CellContext`Gicontador3, 1], 
               Part[$CellContext`Gicontador3, 2]]]]; If[
           MatrixQ[$CellContext`GAristasGrafo], 
           If[MemberQ[
              ToCharacterCode[
               ToString[$CellContext`GAristasGrafo]], 62760] == False, 
            If[MemberQ[
               Flatten[$CellContext`GAristasGrafo], Null] == False, 
             If[Part[
                Dimensions[$CellContext`GAristasGrafo], 2] == 2, 
              If[
               BooleanQ[
                OptionValue[$CellContext`dirigido]], 
               If[
                OptionValue[$CellContext`dirigido], 
                $CellContext`GAristasDirigidas[$CellContext`GAristasGrafo], 
                $CellContext`GAristasNoDirigidas[$CellContext`GAristasGrafo]]]\
]]]]]; $CellContext`AristasMixtasQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         $CellContext`GrafoQ[$CellContext`GGrafo], 
         If[
          And[Select[
             EdgeList[$CellContext`GGrafo], DirectedEdge[
               Part[#, 1], 
               Part[#, 2]] == #& ] != {}, Select[
             EdgeList[$CellContext`GGrafo], UndirectedEdge[
               Part[#, 1], 
               Part[#, 2]] == #& ] != {}], True, 
          False]]; $CellContext`AristasMixtasWolframSystemToCombinatorica[
         Pattern[$CellContext`GAristasGrafo, 
          Blank[]]] := 
       Module[{$CellContext`GGrafoAuxiliar10 = 
          Graph[$CellContext`GAristasGrafo]}, 
         If[
          GraphQ[$CellContext`GGrafoAuxiliar10], 
          If[
           $CellContext`AristasMixtasQ[$CellContext`GGrafoAuxiliar10], 
           Join[
            $CellContext`AristasWolframSystemToCombinatorica[
             Select[
              EdgeList[$CellContext`GGrafoAuxiliar10], DirectedEdge[
                Part[#, 1], 
                Part[#, 2]] == #& ]], 
            $CellContext`AristasWolframSystemToCombinatorica[
             Select[
              EdgeList[$CellContext`GGrafoAuxiliar10], UndirectedEdge[
                Part[#, 1], 
                Part[#, 2]] == #& ]], 
            Reverse[
             $CellContext`AristasWolframSystemToCombinatorica[
              Select[
               EdgeList[$CellContext`GGrafoAuxiliar10], UndirectedEdge[
                 Part[#, 1], 
                 Part[#, 2]] == #& ]], 2]]]]]; 
      Options[$CellContext`Grafo] = {$CellContext`dirigido -> 
         False, $CellContext`vertices -> {}, $CellContext`dimensions3d -> 
         False, $CellContext`pesos -> {}, $CellContext`mostrarpesos -> 
         False, $CellContext`shape -> False}; $CellContext`Grafo[
         Pattern[$CellContext`GAristas, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GAristasNoDirigidas, \
$CellContext`GAristasDirigidas, $CellContext`GLabelsPesos, \
$CellContext`Grafo3d, $CellContext`GrafoNo3d}, \
$CellContext`GAristasNoDirigidas[
            Pattern[$CellContext`GOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`GOAritas, Pattern[$CellContext`Gicontador4, 
               Blank[]] -> UndirectedEdge[
               Part[$CellContext`Gicontador4, 1], 
               
               Part[$CellContext`Gicontador4, 
                2]]]]; $CellContext`GAristasDirigidas[
            Pattern[$CellContext`GOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`GOAritas, Pattern[$CellContext`Gicontador5, 
               Blank[]] -> DirectedEdge[
               Part[$CellContext`Gicontador5, 1], 
               Part[$CellContext`Gicontador5, 2]]]]; $CellContext`GLabelsPesos[
            Pattern[$CellContext`GGrafo, 
             Blank[]], 
            Pattern[$CellContext`GPesos, 
             Blank[]]] := 
          If[Length[$CellContext`GPesos] == EdgeCount[$CellContext`GGrafo], 
            
            Module[{$CellContext`GList1 = 
              EdgeList[$CellContext`GGrafo], $CellContext`GList2 = {}}, 
             For[$CellContext`Gi1 = 1, $CellContext`Gi1 <= 
               Length[$CellContext`GList1], $CellContext`GList2 = 
                Append[$CellContext`GList2, 
                  Part[$CellContext`GList1, $CellContext`Gi1] -> 
                  Part[$CellContext`GPesos, $CellContext`Gi1]]; 
               Increment[$CellContext`Gi1]]; $CellContext`GList2]]; \
$CellContext`Grafo3d[
            Pattern[$CellContext`GOAristas, 
             Blank[]]] := Module[{$CellContext`GVl1}, 
            If[
             OptionValue[$CellContext`shape], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    Text[#2, #]}& )]], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    Text[#2, #]}& )]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Sphere[#, 0.1], Black, 
                  Text[#2, #]}& )], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Sphere[#, 0.1], Black, 
                  Text[#2, #]}& )]]], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]]]]]]; $CellContext`GrafoNo3d[
            Pattern[$CellContext`GOAristas, 
             Blank[]]] := Module[{$CellContext`GVl1}, 
            If[
             OptionValue[$CellContext`shape], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    Text[#2, #]}& )]], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    Text[#2, #]}& )]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Disk[#, 0.1], Black, 
                  Text[#2, #]}& )], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Disk[#, 0.1], Black, 
                  Text[#2, #]}& )]]], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]]]]]]; If[
           And[
            BooleanQ[
             OptionValue[$CellContext`dirigido]], 
            VectorQ[
             OptionValue[$CellContext`vertices]], 
            BooleanQ[
             OptionValue[$CellContext`dimensions3d]], 
            VectorQ[
             OptionValue[$CellContext`pesos]], 
            BooleanQ[
             OptionValue[$CellContext`mostrarpesos]], 
            BooleanQ[
             OptionValue[$CellContext`shape]]], 
           If[
            And[MemberQ[
               OptionValue[$CellContext`vertices], Null] == False, MemberQ[
               OptionValue[$CellContext`pesos], Null] == False], 
            If[
             And[
              Or[
               MatrixQ[$CellContext`GAristas], 
               ToString[$CellContext`GAristas] == ToString[{}]], MemberQ[
                Flatten[$CellContext`GAristas], Null] == False], 
             If[
              Or[Length[$CellContext`GAristas] == Length[
                 OptionValue[$CellContext`pesos]], 
               OptionValue[$CellContext`pesos] == {}], 
              If[
               Or[
                And[
                ToString[$CellContext`GAristas] == ToString[{}], 
                 OptionValue[$CellContext`vertices] != {}], 
                And[
                 MatrixQ[$CellContext`GAristas], Part[
                   Dimensions[$CellContext`GAristas], 2] == 2, MemberQ[
                   ToCharacterCode[
                    ToString[$CellContext`GAristas]], 62760] == False]], 
               If[
                OptionValue[$CellContext`dimensions3d], 
                $CellContext`Grafo3d[$CellContext`GAristas], 
                $CellContext`GrafoNo3d[$CellContext`GAristas]]]]]]]]; \
$CellContext`GrafoQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         GraphQ[$CellContext`GGrafo], True, False]; $CellContext`GrafoCQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         NumericQ[
          $CellContext`V[$CellContext`GGrafo]], 
         If[$CellContext`V[$CellContext`GGrafo] == 0, False, True], 
         False]; $CellContext`PesosAristas[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         $CellContext`GrafoQ[$CellContext`GGrafo], 
         If[
          WeightedGraphQ[$CellContext`GGrafo], 
          If[
           $CellContext`AristasMixtasQ[$CellContext`GGrafo], If[Length[
               Quiet[
                Cases[
                 EdgeList[$CellContext`GGrafo], 
                 Pattern[$CellContext`Gicontador6, 
                   Blank[]] -> NumericQ[
                   
                   PropertyValue[{$CellContext`GGrafo, \
$CellContext`Gicontador6}, EdgeWeight]]]]] == 
             EdgeCount[$CellContext`GGrafo], $CellContext`GList3 = Table[{
                Part[
                 EdgeList[$CellContext`GGrafo], $CellContext`Gi2], 
                PropertyValue[{$CellContext`GGrafo, 
                  Part[
                   EdgeList[$CellContext`GGrafo], $CellContext`Gi2]}, 
                 EdgeWeight]}, {$CellContext`Gi2, 1, 
                EdgeCount[$CellContext`GGrafo]}]]; $CellContext`GList4 = 
            Select[$CellContext`GList3, DirectedEdge[
                Part[#, 1, 1], 
                Part[#, 1, 2]] == Part[#, 1]& , 2]; $CellContext`GList5 = 
            ReplaceAll[
              Select[$CellContext`GList3, UndirectedEdge[
                 Part[#, 1, 1], 
                 Part[#, 1, 2]] == Part[#, 1]& , 2], UndirectedEdge -> 
              DirectedEdge]; Join[$CellContext`GList4, $CellContext`GList5, 
             Reverse[$CellContext`GList5, 3]], 
           If[Length[
              Quiet[
               Cases[
                EdgeList[$CellContext`GGrafo], 
                Pattern[$CellContext`Gicontador6, 
                  Blank[]] -> NumericQ[
                  
                  PropertyValue[{$CellContext`GGrafo, \
$CellContext`Gicontador6}, EdgeWeight]]]]] == EdgeCount[$CellContext`GGrafo], 
            Table[{
              Part[
               EdgeList[$CellContext`GGrafo], $CellContext`Gi2], 
              PropertyValue[{$CellContext`GGrafo, 
                Part[
                 EdgeList[$CellContext`GGrafo], $CellContext`Gi2]}, 
               EdgeWeight]}, {$CellContext`Gi2, 1, 
              EdgeCount[$CellContext`GGrafo]}]]]], 
         If[
          $CellContext`GrafoCQ[$CellContext`GGrafo], 
          If[
           ListQ[
            $CellContext`Edges[$CellContext`GGrafo, EdgeWeight]], 
           DeleteDuplicates[
            $CellContext`Edges[$CellContext`GGrafo, 
             EdgeWeight]]]]]; $CellContext`Valencias[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := Module[{$CellContext`GGrafoAuxiliar15}, 
         If[
          $CellContext`GrafoQ[$CellContext`GGrafo], 
          If[
           $CellContext`AristasMixtasQ[$CellContext`GGrafo], \
$CellContext`GGrafoAuxiliar15 = $CellContext`Grafo[
              $CellContext`AristasMixtasWolframSystemToCombinatorica[
               EdgeList[$CellContext`GGrafo]], $CellContext`dirigido -> 
              True, $CellContext`vertices -> VertexList[$CellContext`GGrafo]]; 
           TableForm[{
              VertexInDegree[$CellContext`GGrafoAuxiliar15], 
              VertexOutDegree[$CellContext`GGrafoAuxiliar15]}, 
             TableHeadings -> {{
               "Grado o valencia interna", "Grado o valencia externa"}, 
               Map[Style[#, Black]& , 
                VertexList[$CellContext`GGrafoAuxiliar15]]}, TableAlignments -> 
             Center], 
           If[
            UndirectedGraphQ[$CellContext`GGrafo], 
            TableForm[{
              VertexDegree[$CellContext`GGrafo]}, 
             TableHeadings -> {{"Grado o valencia"}, 
               Map[Style[#, Black]& , 
                VertexList[$CellContext`GGrafo]]}, TableAlignments -> Center], 
            TableForm[{
              VertexInDegree[$CellContext`GGrafo], 
              VertexOutDegree[$CellContext`GGrafo]}, 
             TableHeadings -> {{
               "Grado o valencia interna", "Grado o valencia externa"}, 
               Map[Style[#, Black]& , 
                VertexList[$CellContext`GGrafo]]}, TableAlignments -> 
             Center]]], 
          If[
           $CellContext`GrafoCQ[$CellContext`GGrafo], \
$CellContext`GGrafoAuxiliar15 = \
$CellContext`CombinatoricaToGraph[$CellContext`GGrafo]; If[
             UndirectedGraphQ[$CellContext`GGrafoAuxiliar15], 
             TableForm[{
               VertexDegree[$CellContext`GGrafoAuxiliar15]}, 
              TableHeadings -> {{"Grado o valencia"}, 
                Map[Style[#, Black]& , 
                 VertexList[$CellContext`GGrafoAuxiliar15]]}, TableAlignments -> 
              Center], 
             TableForm[{
               VertexInDegree[$CellContext`GGrafoAuxiliar15], 
               VertexOutDegree[$CellContext`GGrafoAuxiliar15]}, 
              TableHeadings -> {{
                "Grado o valencia interna", "Grado o valencia externa"}, 
                Map[Style[#, Black]& , 
                 VertexList[$CellContext`GGrafoAuxiliar15]]}, TableAlignments -> 
              Center]]]]]; $CellContext`CantNodos[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := Module[{}, 
         If[
          $CellContext`GrafoQ[$CellContext`GGrafo], 
          VertexCount[$CellContext`GGrafo], 
          If[
           $CellContext`GrafoCQ[$CellContext`GGrafo], 
           $CellContext`V[$CellContext`GGrafo]]]]; $CellContext`CantAristas[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := Module[{}, 
         If[
          $CellContext`GrafoQ[$CellContext`GGrafo], 
          If[
           $CellContext`AristasMixtasQ[$CellContext`GGrafo], 
           Length[
            $CellContext`AristasMixtasWolframSystemToCombinatorica[
             EdgeList[$CellContext`GGrafo]]], 
           EdgeCount[$CellContext`GGrafo]], 
          If[
           $CellContext`GrafoCQ[$CellContext`GGrafo], 
           $CellContext`M[$CellContext`GGrafo]]]]; 
      Options[$CellContext`MGrafo] = {$CellContext`table -> 
         False}; $CellContext`MGrafo[
         Pattern[$CellContext`GGrafo, 
          Blank[]], 
         Pattern[$CellContext`GNodos, 
          Blank[]], 
         OptionsPattern[]] := Module[{$CellContext`GGrafoAuxiliar3}, 
         If[
          VectorQ[$CellContext`GNodos], 
          If[MemberQ[$CellContext`GNodos, Null] == False, 
           If[$CellContext`GNodos != {}, 
            If[
             BooleanQ[
              OptionValue[$CellContext`table]], 
             If[
              $CellContext`GrafoQ[$CellContext`GGrafo], 
              If[Sort[
                 VertexList[$CellContext`GGrafo]] == 
               Sort[$CellContext`GNodos], $CellContext`GGrafoAuxiliar3 = 
                Graph[$CellContext`GNodos, 
                  EdgeList[$CellContext`GGrafo], VertexLabels -> "Name", 
                  ImagePadding -> 10]; If[
                 Not[
                  OptionValue[$CellContext`table]], 
                 MatrixForm[
                  AdjacencyMatrix[$CellContext`GGrafoAuxiliar3]], 
                 TableForm[
                  Normal[
                   AdjacencyMatrix[$CellContext`GGrafoAuxiliar3]], 
                  TableHeadings -> {
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar3]], 
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar3]]}, 
                  TableAlignments -> Center]]], 
              If[
               $CellContext`GrafoCQ[$CellContext`GGrafo], \
$CellContext`GGrafoAuxiliar3 = \
$CellContext`CombinatoricaToGraph[$CellContext`GGrafo]; If[Sort[
                   VertexList[$CellContext`GGrafoAuxiliar3]] == 
                 Sort[$CellContext`GNodos], $CellContext`GGrafoAuxiliar3 = \
$CellContext`Grafo[
                    $CellContext`Edges[$CellContext`GGrafo], \
$CellContext`vertices -> $CellContext`GNodos, $CellContext`dirigido -> Not[
                    $CellContext`UndirectedQ[$CellContext`GGrafo]]]; If[
                   Not[
                    OptionValue[$CellContext`table]], 
                   MatrixForm[
                    AdjacencyMatrix[$CellContext`GGrafoAuxiliar3]], 
                   TableForm[
                    Normal[
                    AdjacencyMatrix[$CellContext`GGrafoAuxiliar3]], 
                    TableHeadings -> {
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar3]], 
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar3]]}, 
                    TableAlignments -> Center]]]]]]]]]]; 
      Options[$CellContext`MPGrafo] = {$CellContext`table -> 
         False}; $CellContext`MPGrafo[
         Pattern[$CellContext`GGrafo, 
          Blank[]], 
         Pattern[$CellContext`GNodos, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GGrafoAuxiliar7, $CellContext`GVl13}, 
         If[
          VectorQ[$CellContext`GNodos], 
          If[MemberQ[$CellContext`GNodos, Null] == False, 
           If[$CellContext`GNodos != {}, 
            If[
             BooleanQ[
              OptionValue[$CellContext`table]], 
             If[MemberQ[{
                 $CellContext`PesosAristas[$CellContext`GGrafo]}, Null] == 
              False, 
              If[
               $CellContext`GrafoQ[$CellContext`GGrafo], 
               If[Sort[
                  VertexList[$CellContext`GGrafo]] == 
                Sort[$CellContext`GNodos], If[
                  $CellContext`AristasMixtasQ[$CellContext`GGrafo], \
$CellContext`GGrafoAuxiliar7 = Graph[$CellContext`GNodos, 
                    $CellContext`AristasCombinatoricaToWolframSystem[
                    $CellContext`AristasMixtasWolframSystemToCombinatorica[
                    EdgeList[$CellContext`GGrafo]], $CellContext`dirigido -> 
                    True]]; $CellContext`GVl13 = Select[
                    Flatten[
                    $CellContext`PesosAristas[$CellContext`GGrafo], 1], 
                    EdgeQ[$CellContext`GGrafoAuxiliar7, #] == 
                    False& ]; $CellContext`GGrafoAuxiliar7 = 
                   Graph[$CellContext`GNodos, 
                    EdgeList[$CellContext`GGrafoAuxiliar7], 
                    EdgeWeight -> $CellContext`GVl13], $CellContext`GVl13 = 
                   Select[
                    Flatten[
                    $CellContext`PesosAristas[$CellContext`GGrafo], 1], 
                    EdgeQ[$CellContext`GGrafo, #] == 
                    False& ]; $CellContext`GGrafoAuxiliar7 = 
                   Graph[$CellContext`GNodos, 
                    EdgeList[$CellContext`GGrafo], 
                    EdgeWeight -> $CellContext`GVl13]]; If[
                  Not[
                   OptionValue[$CellContext`table]], 
                  MatrixForm[
                   WeightedAdjacencyMatrix[$CellContext`GGrafoAuxiliar7]], 
                  TableForm[
                   Normal[
                    WeightedAdjacencyMatrix[$CellContext`GGrafoAuxiliar7]], 
                   TableHeadings -> {
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar7]], 
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar7]]}, 
                   TableAlignments -> Center]]], 
               If[
                $CellContext`GrafoCQ[$CellContext`GGrafo], $CellContext`GVl13 = 
                 Select[
                   Flatten[
                    $CellContext`PesosAristas[$CellContext`GGrafo], 1], 
                   ListQ[#] == 
                   False& ]; $CellContext`GGrafoAuxiliar7 = \
$CellContext`CombinatoricaToGraph[$CellContext`GGrafo]; If[Sort[
                    VertexList[$CellContext`GGrafoAuxiliar7]] == 
                  Sort[$CellContext`GNodos], $CellContext`GGrafoAuxiliar7 = \
$CellContext`Grafo[
                    $CellContext`Edges[$CellContext`GGrafo], \
$CellContext`vertices -> $CellContext`GNodos, $CellContext`dirigido -> Not[
                    $CellContext`UndirectedQ[$CellContext`GGrafo]], \
$CellContext`pesos -> $CellContext`GVl13]; If[
                    Not[
                    OptionValue[$CellContext`table]], 
                    MatrixForm[
                    WeightedAdjacencyMatrix[$CellContext`GGrafoAuxiliar7]], 
                    TableForm[
                    Normal[
                    WeightedAdjacencyMatrix[$CellContext`GGrafoAuxiliar7]], 
                    TableHeadings -> {
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar7]], 
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar7]]}, 
                    TableAlignments -> Center]]]]]]]]]]]; 
      Options[$CellContext`GrafoMI] = {$CellContext`dimensions3d -> 
         False, $CellContext`shape -> False}; $CellContext`GrafoMI[
         Pattern[$CellContext`GMatriz, 
          Blank[]], 
         Pattern[$CellContext`GVertices, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GrafoSinVertexLabels, \
$CellContext`ValidacionIndicenceQ, $CellContext`TransMatrizIncidence, \
$CellContext`GGrafoAuxiliar8}, $CellContext`GrafoSinVertexLabels[
            Pattern[$CellContext`GrafoVertexLabels, 
             Blank[]]] := 
          Module[{$CellContext`VariableOpciones, \
$CellContext`VariablePosicion, $CellContext`VariableParametroi, \
$CellContext`VectorAuxiliarLabels, $CellContext`GrafoSinLabels}, 
            If[
             
             GraphQ[$CellContext`GrafoVertexLabels], \
$CellContext`VariableOpciones = Options[$CellContext`GrafoVertexLabels]; If[
               StringContainsQ[
                ToString[$CellContext`VariableOpciones], "VertexLabels"], 
               For[$CellContext`VariableParametroi = 
                 1, $CellContext`VariableParametroi <= 
                 Length[$CellContext`VariableOpciones], If[
                   StringContainsQ[
                    ToString[
                    
                    Part[$CellContext`VariableOpciones, \
$CellContext`VariableParametroi]], 
                    "VertexLabels"], $CellContext`VariablePosicion = \
$CellContext`VariableParametroi; Break[]]; 
                 Increment[$CellContext`VariableParametroi]]; \
$CellContext`VectorAuxiliarLabels = Part[
                  
                  Part[$CellContext`VariableOpciones, \
$CellContext`VariablePosicion], 2]; If[
                 StringContainsQ[
                  ToString[$CellContext`VectorAuxiliarLabels], "Name"], 
                 
                 For[$CellContext`VariableParametroi = 
                  1, $CellContext`VariableParametroi <= 
                  Length[$CellContext`VectorAuxiliarLabels], 
                  If[Part[$CellContext`VectorAuxiliarLabels, \
$CellContext`VariableParametroi] == "Name", $CellContext`VectorAuxiliarLabels = 
                    Delete[$CellContext`VectorAuxiliarLabels, \
$CellContext`VariableParametroi]]; 
                  Increment[$CellContext`VariableParametroi]]]; \
$CellContext`GrafoSinLabels = Graph[
                  Sort[
                   ReplaceAll[
                    
                    VertexList[$CellContext`GrafoVertexLabels], \
$CellContext`VectorAuxiliarLabels]], 
                  Sort[
                   ReplaceAll[
                    
                    EdgeList[$CellContext`GrafoVertexLabels], \
$CellContext`VectorAuxiliarLabels]], VertexLabels -> "Name", ImagePadding -> 
                  10]; $CellContext`GrafoSinLabels, \
$CellContext`GrafoSinLabels = Graph[
                  Sort[
                   VertexList[$CellContext`GrafoVertexLabels]], 
                  Sort[
                   EdgeList[$CellContext`GrafoVertexLabels]], VertexLabels -> 
                  "Name", ImagePadding -> 
                  10]; $CellContext`GrafoSinLabels]]]; \
$CellContext`ValidacionIndicenceQ[
            Pattern[$CellContext`GGMatriz, 
             Blank[]]] := 
          Module[{$CellContext`GVl14 = 
             True, $CellContext`GVl15, $CellContext`GVl16}, 
            For[$CellContext`Gi11 = 1, $CellContext`Gi11 <= Part[
                Dimensions[$CellContext`GGMatriz], 2], $CellContext`GVl15 = 
               Count[
                 Part[$CellContext`GGMatriz, All, $CellContext`Gi11], 
                 1]; $CellContext`GVl16 = Count[
                 Part[$CellContext`GGMatriz, All, $CellContext`Gi11], -1]; If[
                And[
                 Or[$CellContext`GVl15 != 1, $CellContext`GVl16 != 1], 
                 Or[$CellContext`GVl15 != 1, $CellContext`GVl16 != 0], 
                 
                 Or[$CellContext`GVl15 != 2, $CellContext`GVl16 != 
                  0]], $CellContext`GVl14 = False; Break[]]; 
              Increment[$CellContext`Gi11]]; $CellContext`GVl14]; \
$CellContext`TransMatrizIncidence[
            Pattern[$CellContext`GGMatriz, 
             Blank[]]] := 
          Module[{$CellContext`GMatriz1 = $CellContext`GGMatriz}, 
            For[$CellContext`Gi12 = 1, $CellContext`Gi12 <= Part[
                Dimensions[$CellContext`GMatriz1], 2], If[Count[
                   Part[$CellContext`GMatriz1, All, $CellContext`Gi12], 1] + 
                 Count[
                   Part[$CellContext`GMatriz1, All, $CellContext`Gi12], -1] == 
                1, Part[$CellContext`GMatriz1, All, $CellContext`Gi12] = 
                Replace[
                  Part[$CellContext`GMatriz1, All, $CellContext`Gi12], 1 -> 2,
                   2]]; Increment[$CellContext`Gi12]]; $CellContext`GMatriz1]; 
         If[
           And[
            BooleanQ[
             OptionValue[$CellContext`dimensions3d]], 
            BooleanQ[
             OptionValue[$CellContext`shape]]], 
           If[
            And[
             MatrixQ[$CellContext`GMatriz, IntegerQ], MemberQ[
               Flatten[$CellContext`GMatriz], Null] == False], 
            If[MemberQ[
               ToCharacterCode[
                ToString[$CellContext`GMatriz]], 62760] == False, 
             If[
              $CellContext`MBooleanQ[
               Abs[
                Normal[$CellContext`GMatriz]]], 
              If[
               $CellContext`ValidacionIndicenceQ[
                Normal[$CellContext`GMatriz]], 
               If[
                VectorQ[$CellContext`GVertices], 
                If[MemberQ[$CellContext`GVertices, Null] == False, 
                 If[$CellContext`GVertices != {}, 
                  If[Length[$CellContext`GVertices] == Length[
                    DeleteDuplicates[$CellContext`GVertices]], 
                   If[Part[
                    Dimensions[$CellContext`GMatriz], 1] == 
                    Length[$CellContext`GVertices], 
                    If[ToString[$CellContext`GVertices] != ToString[
                    Table[$CellContext`Gi6, {$CellContext`Gi6, 
                    
                    Length[$CellContext`GVertices]}]], \
$CellContext`GGrafoAuxiliar8 = IncidenceGraph[
                    $CellContext`TransMatrizIncidence[
                    Normal[$CellContext`GMatriz]], VertexLabels -> 
                    Table[$CellContext`Gi6 -> 
                    Part[$CellContext`GVertices, $CellContext`Gi6], \
{$CellContext`Gi6, 
                    Length[$CellContext`GVertices]}], ImagePadding -> 
                    10]; $CellContext`GGrafoAuxiliar8 = \
$CellContext`GrafoSinVertexLabels[$CellContext`GGrafoAuxiliar8], \
$CellContext`GGrafoAuxiliar8 = IncidenceGraph[
                    $CellContext`TransMatrizIncidence[
                    Normal[$CellContext`GMatriz]], VertexLabels -> "Name", 
                    ImagePadding -> 10]]; If[
                    OptionValue[$CellContext`dimensions3d], 
                    If[
                    OptionValue[$CellContext`shape], 
                    Graph3D[
                    VertexList[$CellContext`GGrafoAuxiliar8], 
                    EdgeList[$CellContext`GGrafoAuxiliar8], ImagePadding -> 
                    10, VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    Text[#2, #]}& )], 
                    Graph3D[
                    VertexList[$CellContext`GGrafoAuxiliar8], 
                    EdgeList[$CellContext`GGrafoAuxiliar8], VertexLabels -> 
                    "Name", ImagePadding -> 10]], 
                    If[
                    OptionValue[$CellContext`shape], 
                    Graph[
                    VertexList[$CellContext`GGrafoAuxiliar8], 
                    EdgeList[$CellContext`GGrafoAuxiliar8], ImagePadding -> 
                    10, VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    Text[#2, #]}& )], 
                    Graph[
                    VertexList[$CellContext`GGrafoAuxiliar8], 
                    EdgeList[$CellContext`GGrafoAuxiliar8], VertexLabels -> 
                    "Name", ImagePadding -> 
                    10]]]]]]]]]]]]]]; $CellContext`MBooleanQ[
         Pattern[$CellContext`MatrizSBooleana, 
          Blank[]]] := If[
         MatrixQ[$CellContext`MatrizSBooleana, NumericQ], 
         If[MemberQ[
            Flatten[$CellContext`MatrizSBooleana], Null] == False, 
          
          If[$CellContext`MatrizSBooleana^2 == $CellContext`MatrizSBooleana, 
           True, False], False], False]; $CellContext`ResaltarRuta[
         Pattern[$CellContext`GGrafo, 
          Blank[]], 
         Pattern[$CellContext`GLista, 
          Blank[]]] := If[
         MatrixQ[$CellContext`GLista], 
         If[MemberQ[
            Flatten[$CellContext`GLista], Null] == False, 
          If[MemberQ[
             ToCharacterCode[
              ToString[$CellContext`GLista]], 62760] == False, 
           If[Part[
              Dimensions[$CellContext`GLista], 2] == 2, 
            If[
             $CellContext`GrafoQ[$CellContext`GGrafo], 
             If[
              $CellContext`AristasMixtasQ[$CellContext`GGrafo], \
$CellContext`GGrafoAuxiliar16 = $CellContext`Grafo[
                 $CellContext`AristasMixtasWolframSystemToCombinatorica[
                  EdgeList[$CellContext`GGrafo]], $CellContext`dirigido -> 
                 True, $CellContext`vertices -> 
                 VertexList[$CellContext`GGrafo]]; $CellContext`GList11 = \
$CellContext`AristasCombinatoricaToWolframSystem[$CellContext`GLista, \
$CellContext`dirigido -> True]; 
              HighlightGraph[$CellContext`GGrafoAuxiliar16, \
$CellContext`GList11, VertexLabels -> "Name", ImagePadding -> 10, 
                GraphHighlightStyle -> "Thick"], If[
                
                UndirectedGraphQ[$CellContext`GGrafo], $CellContext`GList11 = \
$CellContext`AristasCombinatoricaToWolframSystem[$CellContext`GLista], \
$CellContext`GList11 = \
$CellContext`AristasCombinatoricaToWolframSystem[$CellContext`GLista, \
$CellContext`dirigido -> True]]; 
              HighlightGraph[$CellContext`GGrafo, $CellContext`GList11, 
                VertexLabels -> "Name", ImagePadding -> 10, 
                GraphHighlightStyle -> "Thick"]], 
             If[
              $CellContext`GrafoCQ[$CellContext`GGrafo], \
$CellContext`GGrafoAuxiliar16 = \
$CellContext`CombinatoricaToGraph[$CellContext`GGrafo]; If[
                
                UndirectedGraphQ[$CellContext`GGrafoAuxiliar16], \
$CellContext`GList11 = \
$CellContext`AristasCombinatoricaToWolframSystem[$CellContext`GLista], \
$CellContext`GList11 = \
$CellContext`AristasCombinatoricaToWolframSystem[$CellContext`GLista, \
$CellContext`dirigido -> True]]; 
              HighlightGraph[$CellContext`GGrafoAuxiliar16, \
$CellContext`GList11, VertexLabels -> "Name", ImagePadding -> 10, 
                GraphHighlightStyle -> "Thick"]]]]]]]; 
      Options[$CellContext`CombinatoricaToGraph] = {$CellContext`dimensions3d -> 
         False, $CellContext`mostrarpesos -> False, $CellContext`shape -> 
         False}; $CellContext`CombinatoricaToGraph[
         Pattern[$CellContext`GGrafo, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GrafoO3d, $CellContext`GrafoONo3d}, \
$CellContext`GrafoO3d[
            Pattern[$CellContext`GOGrafo, 
             Blank[]]] := Module[{$CellContext`GVl2}, 
            If[
             $CellContext`UndirectedQ[$CellContext`GOGrafo], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                True, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> True, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                True, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> True, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]]]]; $CellContext`GrafoONo3d[
            Pattern[$CellContext`GOGrafo, 
             Blank[]]] := Module[{$CellContext`GVl2}, 
            If[
             $CellContext`UndirectedQ[$CellContext`GOGrafo], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                False, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> False, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                False, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> False, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]]]]; If[
           And[
            BooleanQ[
             OptionValue[$CellContext`dimensions3d]], 
            BooleanQ[
             OptionValue[$CellContext`mostrarpesos]], 
            BooleanQ[
             OptionValue[$CellContext`shape]]], 
           If[
            $CellContext`GrafoCQ[$CellContext`GGrafo], 
            If[
             OptionValue[$CellContext`dimensions3d], 
             $CellContext`GrafoO3d[$CellContext`GGrafo], 
             $CellContext`GrafoONo3d[$CellContext`GGrafo]]]]]; 
      Options[$CellContext`MIGrafo] = {$CellContext`edgesgraph -> {}, \
$CellContext`table -> False}; $CellContext`MIGrafo[
         Pattern[$CellContext`GGrafo, 
          Blank[]], 
         Pattern[$CellContext`GNodos, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GGrafoAuxiliar9, $CellContext`GMatriz2, \
$CellContext`GVl17 = True}, 
         If[
          VectorQ[$CellContext`GNodos], 
          If[MemberQ[$CellContext`GNodos, Null] == False, 
           If[$CellContext`GNodos != {}, 
            If[
             BooleanQ[
              OptionValue[$CellContext`table]], 
             If[
              Or[
               MatrixQ[
                OptionValue[$CellContext`edgesgraph]], 
               OptionValue[$CellContext`edgesgraph] == {}], 
              If[
               Or[MemberQ[
                  ToCharacterCode[
                   ToString[
                    OptionValue[$CellContext`edgesgraph]]], 62760] == False, 
                OptionValue[$CellContext`edgesgraph] == {}], 
               If[OptionValue[$CellContext`edgesgraph] != {}, 
                 If[Part[
                    Dimensions[
                    OptionValue[$CellContext`edgesgraph]], 2] != 
                  2, $CellContext`GVl17 = False]]; If[$CellContext`GVl17, 
                 If[
                  Or[MemberQ[
                    Flatten[
                    OptionValue[$CellContext`edgesgraph]], Null] == False, 
                   OptionValue[$CellContext`edgesgraph] == {}], 
                  If[
                   $CellContext`GrafoQ[$CellContext`GGrafo], 
                   If[EdgeList[$CellContext`GGrafo] != {}, 
                    If[
                    $CellContext`AristasMixtasQ[$CellContext`GGrafo], 
                    If[
                    Or[Sort[
                    OptionValue[$CellContext`edgesgraph]] == Sort[
                    $CellContext`AristasMixtasWolframSystemToCombinatorica[
                    EdgeList[$CellContext`GGrafo]]], 
                    OptionValue[$CellContext`edgesgraph] == {}], 
                    If[Sort[
                    VertexList[$CellContext`GGrafo]] == 
                    Sort[$CellContext`GNodos], 
                    If[OptionValue[$CellContext`edgesgraph] != {}, \
$CellContext`GGrafoAuxiliar9 = $CellContext`Grafo[
                    
                    OptionValue[$CellContext`edgesgraph], \
$CellContext`vertices -> $CellContext`GNodos, $CellContext`dirigido -> 
                    True], $CellContext`GGrafoAuxiliar9 = 
                    Graph[$CellContext`GNodos, 
                    EdgeList[$CellContext`GGrafo]]]; If[
                    Not[
                    OptionValue[$CellContext`table]], $CellContext`GMatriz2 = 
                    Normal[
                    
                    IncidenceMatrix[$CellContext`GGrafoAuxiliar9]]; \
$CellContext`GMatriz2 = Replace[$CellContext`GMatriz2, 2 -> 1, 2]; 
                    MatrixForm[$CellContext`GMatriz2], $CellContext`GMatriz2 = 
                    Normal[
                    
                    IncidenceMatrix[$CellContext`GGrafoAuxiliar9]]; \
$CellContext`GMatriz2 = Replace[$CellContext`GMatriz2, 2 -> 1, 2]; 
                    MatrixForm[$CellContext`GMatriz2]; 
                    TableForm[$CellContext`GMatriz2, TableHeadings -> {
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar9]], 
                    Map[Style[#, Black]& , 
                    EdgeList[$CellContext`GGrafoAuxiliar9]]}, TableAlignments -> 
                    Center]]]], 
                    If[
                    Or[Sort[
                    OptionValue[$CellContext`edgesgraph]] == Sort[
                    $CellContext`AristasWolframSystemToCombinatorica[
                    EdgeList[$CellContext`GGrafo]]], 
                    OptionValue[$CellContext`edgesgraph] == {}], 
                    If[Sort[
                    VertexList[$CellContext`GGrafo]] == 
                    Sort[$CellContext`GNodos], 
                    If[OptionValue[$CellContext`edgesgraph] != {}, \
$CellContext`GGrafoAuxiliar9 = $CellContext`Grafo[
                    
                    OptionValue[$CellContext`edgesgraph], \
$CellContext`vertices -> $CellContext`GNodos, $CellContext`dirigido -> Not[
                    
                    UndirectedGraphQ[$CellContext`GGrafo]]], \
$CellContext`GGrafoAuxiliar9 = Graph[$CellContext`GNodos, 
                    EdgeList[$CellContext`GGrafo]]]; If[
                    Not[
                    OptionValue[$CellContext`table]], $CellContext`GMatriz2 = 
                    Normal[
                    
                    IncidenceMatrix[$CellContext`GGrafoAuxiliar9]]; \
$CellContext`GMatriz2 = Replace[$CellContext`GMatriz2, 2 -> 1, 2]; 
                    MatrixForm[$CellContext`GMatriz2], $CellContext`GMatriz2 = 
                    Normal[
                    
                    IncidenceMatrix[$CellContext`GGrafoAuxiliar9]]; \
$CellContext`GMatriz2 = Replace[$CellContext`GMatriz2, 2 -> 1, 2]; 
                    MatrixForm[$CellContext`GMatriz2]; 
                    TableForm[$CellContext`GMatriz2, TableHeadings -> {
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar9]], 
                    Map[Style[#, Black]& , 
                    EdgeList[$CellContext`GGrafoAuxiliar9]]}, TableAlignments -> 
                    Center]]]]]], 
                   If[
                    $CellContext`GrafoCQ[$CellContext`GGrafo], \
$CellContext`GGrafoAuxiliar9 = \
$CellContext`CombinatoricaToGraph[$CellContext`GGrafo]; 
                    If[EdgeList[$CellContext`GGrafoAuxiliar9] != {}, 
                    If[
                    Or[Sort[
                    OptionValue[$CellContext`edgesgraph]] == Sort[
                    $CellContext`AristasWolframSystemToCombinatorica[
                    EdgeList[$CellContext`GGrafoAuxiliar9]]], 
                    OptionValue[$CellContext`edgesgraph] == {}], 
                    If[Sort[
                    VertexList[$CellContext`GGrafoAuxiliar9]] == 
                    Sort[$CellContext`GNodos], 
                    If[OptionValue[$CellContext`edgesgraph] != {}, \
$CellContext`GGrafoAuxiliar9 = $CellContext`Grafo[
                    
                    OptionValue[$CellContext`edgesgraph], \
$CellContext`vertices -> $CellContext`GNodos, $CellContext`dirigido -> Not[
                    $CellContext`UndirectedQ[$CellContext`GGrafo]]], \
$CellContext`GGrafoAuxiliar9 = $CellContext`Grafo[
                    $CellContext`Edges[$CellContext`GGrafo], \
$CellContext`vertices -> $CellContext`GNodos, $CellContext`dirigido -> Not[
                    $CellContext`UndirectedQ[$CellContext`GGrafo]]]]; If[
                    Not[
                    OptionValue[$CellContext`table]], $CellContext`GMatriz2 = 
                    Normal[
                    
                    IncidenceMatrix[$CellContext`GGrafoAuxiliar9]]; \
$CellContext`GMatriz2 = Replace[$CellContext`GMatriz2, 2 -> 1, 2]; 
                    MatrixForm[$CellContext`GMatriz2]; 
                    MatrixForm[$CellContext`GMatriz2], $CellContext`GMatriz2 = 
                    Normal[
                    
                    IncidenceMatrix[$CellContext`GGrafoAuxiliar9]]; \
$CellContext`GMatriz2 = Replace[$CellContext`GMatriz2, 2 -> 1, 2]; 
                    MatrixForm[$CellContext`GMatriz2]; 
                    TableForm[$CellContext`GMatriz2, TableHeadings -> {
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar9]], 
                    Map[Style[#, Black]& , 
                    EdgeList[$CellContext`GGrafoAuxiliar9]]}, TableAlignments -> 
                    Center]]]]]]]]]]]]]]]]; $CellContext`GrafoPonderadoNQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         $CellContext`GrafoQ[$CellContext`GGrafo], 
         If[
          $CellContext`GrafoPonderadoQ[$CellContext`GGrafo], If[
            $CellContext`AristasMixtasQ[$CellContext`GGrafo], \
$CellContext`GGrafoAuxiliar36 = $CellContext`Grafo[
              $CellContext`AristasMixtasWolframSystemToCombinatorica[
               EdgeList[$CellContext`GGrafo]], $CellContext`dirigido -> 
              True], $CellContext`GGrafoAuxiliar36 = $CellContext`GGrafo]; If[
            VectorQ[
             Select[
              Flatten[
               $CellContext`PesosAristas[$CellContext`GGrafo]], 
              EdgeQ[$CellContext`GGrafoAuxiliar36, #] == False& ], NumericQ], 
            True, False], False], 
         If[
          $CellContext`GrafoCQ[$CellContext`GGrafo], 
          If[
           $CellContext`GrafoPonderadoQ[$CellContext`GGrafo], \
$CellContext`GGrafoAuxiliar36 = \
$CellContext`CombinatoricaToGraph[$CellContext`GGrafo]; If[
             VectorQ[
              Select[
               Flatten[
                $CellContext`PesosAristas[$CellContext`GGrafoAuxiliar36]], 
               EdgeQ[$CellContext`GGrafoAuxiliar36, #] == False& ], NumericQ],
              True, False], False]]]; $CellContext`GrafoPonderadoQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         $CellContext`GrafoQ[$CellContext`GGrafo], 
         If[
          Not[
           MemberQ[{
             $CellContext`PesosAristas[$CellContext`GGrafo]}, Null]], True, 
          False], 
         If[
          $CellContext`GrafoCQ[$CellContext`GGrafo], 
          If[
           Not[
            MemberQ[{
              $CellContext`PesosAristas[$CellContext`GGrafo]}, Null]], True, 
           False]]]); Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.670165317934126*^9, 3.6701654030402436`*^9, 3.670165450310856*^9, 
   3.6785570694549656`*^9, 3.678557143383082*^9, {3.678557333410801*^9, 
   3.6785573463623734`*^9}, 3.8011565680045686`*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"2778809f-ab51-4551-ba51-7ceed28fcffe"]
}, Open  ]]
},
WindowSize->{1366, 685},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5b114d3b-3402-4918-8df9-fb5907941299"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 149396, 3167, 24147, "Input",ExpressionUUID->"42d06299-c361-47df-9a73-6a8f9bea65d5"],
Cell[149979, 3191, 72940, 1504, 892, "Output",ExpressionUUID->"2778809f-ab51-4551-ba51-7ceed28fcffe"]
}, Open  ]]
}
]
*)

